/*
 * Decompiled with CFR 0.152.
 */
package cucumber.runtime.java8;

import cucumber.api.java8.StepdefBody;
import cucumber.runtime.Argument;
import cucumber.runtime.CucumberException;
import cucumber.runtime.JdkPatternArgumentMatcher;
import cucumber.runtime.ParameterInfo;
import cucumber.runtime.StepDefinition;
import cucumber.runtime.Utils;
import gherkin.pickles.PickleStep;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import net.jodah.typetools.TypeResolver;

public class Java8StepDefinition
implements StepDefinition {
    private final Pattern pattern;
    private final long timeoutMillis;
    private final StepdefBody body;
    private final JdkPatternArgumentMatcher argumentMatcher;
    private final StackTraceElement location;
    private final List<ParameterInfo> parameterInfos;
    private final Method method;

    public <T extends StepdefBody> Java8StepDefinition(String pattern, long timeoutMillis, Class<T> bodyClass, T body) {
        this.pattern = Pattern.compile(pattern);
        this.timeoutMillis = timeoutMillis;
        this.body = body;
        this.argumentMatcher = new JdkPatternArgumentMatcher(this.pattern);
        this.location = new Exception().getStackTrace()[2];
        this.method = this.getAcceptMethod(body.getClass());
        try {
            Type[] arguments = TypeResolver.resolveRawArguments(bodyClass, body.getClass());
            this.parameterInfos = ParameterInfo.fromTypes((Type[])this.verifyNotListOrMap(arguments));
        }
        catch (CucumberException e) {
            throw e;
        }
        catch (Exception e) {
            throw new CucumberException((Throwable)e);
        }
    }

    private Method getAcceptMethod(Class<? extends StepdefBody> bodyClass) {
        ArrayList<Method> acceptMethods = new ArrayList<Method>();
        for (Method method : bodyClass.getDeclaredMethods()) {
            if (method.isBridge() || method.isSynthetic() || !"accept".equals(method.getName())) continue;
            acceptMethods.add(method);
        }
        if (acceptMethods.size() != 1) {
            throw new IllegalStateException(String.format("Expected single 'accept' method on body class, found '%s'", acceptMethods));
        }
        return (Method)acceptMethods.get(0);
    }

    private Type[] verifyNotListOrMap(Type[] argumentTypes) {
        for (Type argumentType : argumentTypes) {
            Class argumentClass;
            if (!(argumentType instanceof Class) || !List.class.isAssignableFrom(argumentClass = (Class)argumentType) && !Map.class.isAssignableFrom(argumentClass)) continue;
            throw this.withLocation(new CucumberException("Can't use " + argumentClass.getName() + " in lambda step definition. Declare a DataTable argument instead and convert manually with asList/asLists/asMap/asMaps"));
        }
        return argumentTypes;
    }

    private CucumberException withLocation(CucumberException exception) {
        exception.setStackTrace(new StackTraceElement[]{this.location});
        return exception;
    }

    public List<Argument> matchedArguments(PickleStep step) {
        return this.argumentMatcher.argumentsFrom(step.getText());
    }

    public String getLocation(boolean detail) {
        return this.location.getFileName() + ":" + this.location.getLineNumber();
    }

    public Integer getParameterCount() {
        return this.parameterInfos.size();
    }

    public ParameterInfo getParameterType(int n, Type argumentType) throws IndexOutOfBoundsException {
        return this.parameterInfos.get(n);
    }

    public void execute(String language, Object[] args) throws Throwable {
        Utils.invoke((Object)this.body, (Method)this.method, (long)this.timeoutMillis, (Object[])args);
    }

    public boolean isDefinedAt(StackTraceElement stackTraceElement) {
        return this.location.getFileName() != null && this.location.getFileName().equals(stackTraceElement.getFileName());
    }

    public String getPattern() {
        return this.pattern.pattern();
    }

    public boolean isScenarioScoped() {
        return true;
    }
}

