/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.java;

import io.cucumber.core.backend.HookDefinition;
import io.cucumber.core.backend.Lookup;
import io.cucumber.core.backend.TestCaseState;
import io.cucumber.java.AbstractGlueDefinition;
import io.cucumber.java.After;
import io.cucumber.java.AfterStep;
import io.cucumber.java.Before;
import io.cucumber.java.BeforeStep;
import io.cucumber.java.InvalidMethodSignatureException;
import io.cucumber.java.Scenario;
import io.cucumber.java.Step;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.Objects;
import java.util.Optional;

final class JavaHookDefinition
extends AbstractGlueDefinition
implements HookDefinition {
    private final String tagExpression;
    private final int order;
    private final HookDefinition.HookType hookType;

    JavaHookDefinition(HookDefinition.HookType hookType, Method method, String tagExpression, int order, Lookup lookup) {
        super(JavaHookDefinition.requireValidMethod(hookType, method), lookup);
        this.hookType = Objects.requireNonNull(hookType);
        this.tagExpression = Objects.requireNonNull(tagExpression, "tag-expression may not be null");
        this.order = order;
    }

    private static Method requireValidMethod(HookDefinition.HookType hookType, Method method) {
        Type returnType = method.getGenericReturnType();
        if (!Void.class.equals((Object)returnType) && !Void.TYPE.equals(returnType)) {
            throw JavaHookDefinition.createInvalidSignatureException(method, hookType);
        }
        Class<?>[] parameterTypes = method.getParameterTypes();
        switch (hookType) {
            case BEFORE_STEP: 
            case AFTER_STEP: {
                JavaHookDefinition.validateStepHookParameters(method, parameterTypes, hookType);
                break;
            }
            case BEFORE: 
            case AFTER: {
                JavaHookDefinition.validateScenarioHookParameters(method, parameterTypes, hookType);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown hook type: " + hookType);
            }
        }
        return method;
    }

    private static void validateScenarioHookParameters(Method method, Class<?>[] parameterTypes, HookDefinition.HookType hookType) {
        Class<?> parameterType;
        if (parameterTypes.length > 1) {
            throw JavaHookDefinition.createInvalidSignatureException(method, hookType);
        }
        if (parameterTypes.length == 1 && !Object.class.equals(parameterType = parameterTypes[0]) && !Scenario.class.equals(parameterType)) {
            throw JavaHookDefinition.createInvalidSignatureException(method, hookType);
        }
    }

    private static void validateStepHookParameters(Method method, Class<?>[] parameterTypes, HookDefinition.HookType hookType) {
        Class<?> secondParam;
        Class<?> firstParam;
        if (parameterTypes.length > 2) {
            throw JavaHookDefinition.createInvalidSignatureException(method, hookType);
        }
        if (parameterTypes.length >= 1 && !Object.class.equals(firstParam = parameterTypes[0]) && !Scenario.class.equals(firstParam)) {
            throw JavaHookDefinition.createInvalidSignatureException(method, hookType);
        }
        if (parameterTypes.length == 2 && !Object.class.equals(secondParam = parameterTypes[1]) && !Step.class.equals(secondParam)) {
            throw JavaHookDefinition.createInvalidSignatureException(method, hookType);
        }
    }

    private static InvalidMethodSignatureException createInvalidSignatureException(Method method, HookDefinition.HookType hookType) {
        InvalidMethodSignatureException.InvalidMethodSignatureExceptionBuilder exceptionBuilder = InvalidMethodSignatureException.builder(method);
        switch (hookType) {
            case BEFORE: {
                exceptionBuilder.addAnnotation(Before.class);
                break;
            }
            case AFTER: {
                exceptionBuilder.addAnnotation(After.class);
                break;
            }
            case BEFORE_STEP: {
                exceptionBuilder.addAnnotation(BeforeStep.class);
                break;
            }
            case AFTER_STEP: {
                exceptionBuilder.addAnnotation(AfterStep.class);
            }
        }
        exceptionBuilder.addSignature("public void hook()").addSignature("public void hook(io.cucumber.java.Scenario scenario)");
        if (hookType == HookDefinition.HookType.BEFORE_STEP || hookType == HookDefinition.HookType.AFTER_STEP) {
            exceptionBuilder.addSignature("public void hook(io.cucumber.java.Scenario scenario, io.cucumber.java.Step step)");
        }
        return exceptionBuilder.build();
    }

    public void execute(TestCaseState state) {
        int paramCount = this.method.getParameterTypes().length;
        Object[] args = paramCount == 0 ? new Object[]{} : (paramCount == 1 ? new Object[]{new Scenario(state)} : new Object[]{new Scenario(state), state.geCurrentPickleStep().map(Step::new).orElse(null)});
        this.invokeMethod(args);
    }

    public String getTagExpression() {
        return this.tagExpression;
    }

    public int getOrder() {
        return this.order;
    }

    public Optional<HookDefinition.HookType> getHookType() {
        return Optional.of(this.hookType);
    }
}

