/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.java;

import io.cucumber.core.backend.Snippet;
import io.cucumber.datatable.DataTable;
import java.lang.reflect.Type;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;

abstract class AbstractJavaSnippet
implements Snippet {
    AbstractJavaSnippet() {
    }

    public Optional<String> language() {
        return Optional.of("java");
    }

    public final String tableHint() {
        return "    // For automatic transformation, change DataTable to one of\n    // E, List<E>, List<List<E>>, List<Map<K,V>>, Map<K,V> or\n    // Map<K, List<V>>. E,K,V must be a String, Integer, Float,\n    // Double, Byte, Short, Long, BigInteger or BigDecimal.\n    //\n    // For other transformations you can register a DataTableType.\n";
    }

    public final String arguments(Map<String, Type> arguments) {
        return arguments.entrySet().stream().map(argType -> this.getArgType((Type)argType.getValue()) + " " + (String)argType.getKey()).collect(Collectors.joining(", "));
    }

    private String getArgType(Type argType) {
        if (argType instanceof Class) {
            Class cType = (Class)argType;
            if (cType.equals(DataTable.class)) {
                return cType.getName();
            }
            return cType.getSimpleName();
        }
        return argType.toString();
    }

    public final String escapePattern(String pattern) {
        return pattern.replace("\\", "\\\\").replace("\"", "\\\"");
    }
}

