/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.java;

import io.cucumber.core.backend.DefaultDataTableEntryTransformerDefinition;
import io.cucumber.core.backend.Lookup;
import io.cucumber.datatable.TableCellByTypeTransformer;
import io.cucumber.datatable.TableEntryByTypeTransformer;
import io.cucumber.java.AbstractDatatableElementTransformerDefinition;
import io.cucumber.java.DefaultDataTableEntryTransformer;
import io.cucumber.java.InvalidMethodSignatureException;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Map;

class JavaDefaultDataTableEntryTransformerDefinition
extends AbstractDatatableElementTransformerDefinition
implements DefaultDataTableEntryTransformerDefinition {
    private final TableEntryByTypeTransformer transformer;
    private final boolean headersToProperties;

    JavaDefaultDataTableEntryTransformerDefinition(Method method, Lookup lookup) {
        this(method, lookup, false, new String[0]);
    }

    JavaDefaultDataTableEntryTransformerDefinition(Method method, Lookup lookup, boolean headersToProperties, String[] emptyPatterns) {
        super(JavaDefaultDataTableEntryTransformerDefinition.requireValidMethod(method), lookup, emptyPatterns);
        this.headersToProperties = headersToProperties;
        this.transformer = (entryValue, toValueType, cellTransformer) -> this.execute(this.replaceEmptyPatternsWithEmptyString(entryValue), toValueType, cellTransformer);
    }

    private static Method requireValidMethod(Method method) {
        Class<?> returnType = method.getReturnType();
        if (Void.class.equals(returnType) || Void.TYPE.equals(returnType)) {
            throw JavaDefaultDataTableEntryTransformerDefinition.createInvalidSignatureException(method);
        }
        Class<?>[] parameterTypes = method.getParameterTypes();
        Type[] genericParameterTypes = method.getGenericParameterTypes();
        if (parameterTypes.length < 2 || parameterTypes.length > 3) {
            throw JavaDefaultDataTableEntryTransformerDefinition.createInvalidSignatureException(method);
        }
        Type parameterType = genericParameterTypes[0];
        if (!Object.class.equals((Object)parameterType)) {
            Type[] typeParameters;
            if (!(parameterType instanceof ParameterizedType)) {
                throw JavaDefaultDataTableEntryTransformerDefinition.createInvalidSignatureException(method);
            }
            ParameterizedType parameterizedType = (ParameterizedType)parameterType;
            Type rawType = parameterizedType.getRawType();
            if (!Map.class.equals((Object)rawType)) {
                throw JavaDefaultDataTableEntryTransformerDefinition.createInvalidSignatureException(method);
            }
            for (Type typeParameter : typeParameters = parameterizedType.getActualTypeArguments()) {
                if (String.class.equals((Object)typeParameter)) continue;
                throw JavaDefaultDataTableEntryTransformerDefinition.createInvalidSignatureException(method);
            }
        }
        if (!Type.class.equals(parameterTypes[1])) {
            throw JavaDefaultDataTableEntryTransformerDefinition.createInvalidSignatureException(method);
        }
        if (parameterTypes.length == 3 && !Object.class.equals(parameterTypes[2]) && !TableCellByTypeTransformer.class.equals(parameterTypes[2])) {
            throw JavaDefaultDataTableEntryTransformerDefinition.createInvalidSignatureException(method);
        }
        return method;
    }

    private static InvalidMethodSignatureException createInvalidSignatureException(Method method) {
        return InvalidMethodSignatureException.builder(method).addAnnotation(DefaultDataTableEntryTransformer.class).addSignature("public Object defaultDataTableEntry(Map<String, String> fromValue, Type toValueType)").addSignature("public Object defaultDataTableEntry(Object fromValue, Type toValueType)").build();
    }

    public TableEntryByTypeTransformer tableEntryByTypeTransformer() {
        return this.transformer;
    }

    public boolean headersToProperties() {
        return this.headersToProperties;
    }

    private Object execute(Map<String, String> fromValue, Type toValueType, TableCellByTypeTransformer cellTransformer) {
        Object[] args = this.method.getParameterTypes().length == 3 ? new Object[]{fromValue, toValueType, cellTransformer} : new Object[]{fromValue, toValueType};
        return this.invokeMethod(args);
    }
}

