/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.core.runner;

import io.cucumber.core.eventbus.EventBus;
import io.cucumber.core.gherkin.Step;
import io.cucumber.core.runner.DefinitionArgument;
import io.cucumber.core.runner.ExecutionMode;
import io.cucumber.core.runner.HookTestStep;
import io.cucumber.core.runner.PickleStepDefinitionMatch;
import io.cucumber.core.runner.TestCaseState;
import io.cucumber.core.runner.TestStep;
import io.cucumber.plugin.event.Argument;
import io.cucumber.plugin.event.StepArgument;
import io.cucumber.plugin.event.TestCase;
import java.net.URI;
import java.util.Collections;
import java.util.List;
import java.util.UUID;

final class PickleStepTestStep
extends TestStep
implements io.cucumber.plugin.event.PickleStepTestStep,
io.cucumber.core.backend.Step {
    private final URI uri;
    private final Step step;
    private final List<HookTestStep> afterStepHookSteps;
    private final List<HookTestStep> beforeStepHookSteps;
    private final PickleStepDefinitionMatch definitionMatch;

    PickleStepTestStep(UUID id, URI uri, Step step, PickleStepDefinitionMatch definitionMatch) {
        this(id, uri, step, Collections.emptyList(), Collections.emptyList(), definitionMatch);
    }

    PickleStepTestStep(UUID id, URI uri, Step step, List<HookTestStep> beforeStepHookSteps, List<HookTestStep> afterStepHookSteps, PickleStepDefinitionMatch definitionMatch) {
        super(id, definitionMatch);
        this.uri = uri;
        this.step = step;
        this.afterStepHookSteps = afterStepHookSteps;
        this.beforeStepHookSteps = beforeStepHookSteps;
        this.definitionMatch = definitionMatch;
    }

    @Override
    ExecutionMode run(TestCase testCase, EventBus bus, TestCaseState state, ExecutionMode executionMode) {
        ExecutionMode nextExecutionMode = executionMode;
        state.setCurrentPickleStep(this);
        for (HookTestStep before : this.beforeStepHookSteps) {
            nextExecutionMode = before.run(testCase, bus, state, executionMode).next(nextExecutionMode);
        }
        nextExecutionMode = super.run(testCase, bus, state, nextExecutionMode).next(nextExecutionMode);
        for (HookTestStep after : this.afterStepHookSteps) {
            nextExecutionMode = after.run(testCase, bus, state, executionMode).next(nextExecutionMode);
        }
        state.clearCurrentPickleStep();
        return nextExecutionMode;
    }

    List<HookTestStep> getBeforeStepHookSteps() {
        return this.beforeStepHookSteps;
    }

    List<HookTestStep> getAfterStepHookSteps() {
        return this.afterStepHookSteps;
    }

    public String getPattern() {
        return this.definitionMatch.getPattern();
    }

    public Step getStep() {
        return this.step;
    }

    public List<Argument> getDefinitionArgument() {
        return DefinitionArgument.createArguments(this.definitionMatch.getArguments());
    }

    public PickleStepDefinitionMatch getDefinitionMatch() {
        return this.definitionMatch;
    }

    public StepArgument getStepArgument() {
        return this.step.getArgument();
    }

    public int getStepLine() {
        return this.step.getLine();
    }

    public URI getUri() {
        return this.uri;
    }

    public String getStepText() {
        return this.step.getText();
    }

    @Override
    public String getKeyword() {
        return this.step.getKeyword();
    }

    @Override
    public String getText() {
        return this.step.getText();
    }

    @Override
    public int getLine() {
        return this.step.getLine();
    }
}

