/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.core.plugin;

import io.cucumber.core.exception.CucumberException;
import io.cucumber.core.exception.ExceptionUtils;
import io.cucumber.core.gherkin.DataTableArgument;
import io.cucumber.core.plugin.Format;
import io.cucumber.core.plugin.Formats;
import io.cucumber.core.plugin.NiceAppendable;
import io.cucumber.core.plugin.UTF8OutputStreamWriter;
import io.cucumber.datatable.DataTable;
import io.cucumber.datatable.DataTableFormatter;
import io.cucumber.plugin.ColorAware;
import io.cucumber.plugin.ConcurrentEventListener;
import io.cucumber.plugin.event.Argument;
import io.cucumber.plugin.event.EmbedEvent;
import io.cucumber.plugin.event.EventPublisher;
import io.cucumber.plugin.event.PickleStepTestStep;
import io.cucumber.plugin.event.Result;
import io.cucumber.plugin.event.StepArgument;
import io.cucumber.plugin.event.TestCase;
import io.cucumber.plugin.event.TestCaseStarted;
import io.cucumber.plugin.event.TestRunFinished;
import io.cucumber.plugin.event.TestStepFinished;
import io.cucumber.plugin.event.WriteEvent;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.StringReader;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;

public final class PrettyFormatter
implements ConcurrentEventListener,
ColorAware {
    private static final String SCENARIO_INDENT = "";
    private static final String STEP_INDENT = "  ";
    private static final String STEP_SCENARIO_INDENT = "    ";
    private final Map<UUID, Integer> commentStartIndex = new HashMap<UUID, Integer>();
    private final NiceAppendable out;
    private Formats formats = Formats.ansi();

    public PrettyFormatter(OutputStream out) {
        this.out = new NiceAppendable(new UTF8OutputStreamWriter(out));
    }

    public void setEventPublisher(EventPublisher publisher) {
        publisher.registerHandlerFor(TestCaseStarted.class, this::handleTestCaseStarted);
        publisher.registerHandlerFor(TestStepFinished.class, this::handleTestStepFinished);
        publisher.registerHandlerFor(WriteEvent.class, this::handleWrite);
        publisher.registerHandlerFor(EmbedEvent.class, this::handleEmbed);
        publisher.registerHandlerFor(TestRunFinished.class, this::handleTestRunFinished);
    }

    private void handleTestCaseStarted(TestCaseStarted event) {
        this.out.println();
        this.preCalculateLocationIndent(event);
        this.printTags(event);
        this.printScenarioDefinition(event);
    }

    private void handleTestStepFinished(TestStepFinished event) {
        this.printStep(event);
        this.printError(event);
    }

    private void handleWrite(WriteEvent event) {
        this.out.println();
        this.printText(event);
        this.out.println();
    }

    private void handleEmbed(EmbedEvent event) {
        this.out.println();
        this.printEmbedding(event);
        this.out.println();
    }

    private void handleTestRunFinished(TestRunFinished event) {
        this.printError(event);
        this.out.close();
    }

    private void preCalculateLocationIndent(TestCaseStarted event) {
        TestCase testCase = event.getTestCase();
        Integer longestStep = testCase.getTestSteps().stream().filter(PickleStepTestStep.class::isInstance).map(PickleStepTestStep.class::cast).map(PickleStepTestStep::getStep).map(step -> this.formatPlainStep(step.getKeyword(), step.getText()).length()).max(Comparator.naturalOrder()).orElse(0);
        int scenarioLength = this.formatScenarioDefinition(testCase).length();
        this.commentStartIndex.put(testCase.getId(), Math.max(longestStep, scenarioLength) + 1);
    }

    private void printTags(TestCaseStarted event) {
        List tags = event.getTestCase().getTags();
        if (!tags.isEmpty()) {
            this.out.println(SCENARIO_INDENT + String.join((CharSequence)" ", tags));
        }
    }

    private void printScenarioDefinition(TestCaseStarted event) {
        TestCase testCase = event.getTestCase();
        String definitionText = this.formatScenarioDefinition(testCase);
        String path = PrettyFormatter.relativize(testCase.getUri()).getSchemeSpecificPart();
        String locationIndent = this.calculateLocationIndent(event.getTestCase(), SCENARIO_INDENT + definitionText);
        this.out.println(SCENARIO_INDENT + definitionText + locationIndent + this.formatLocation(path + ":" + testCase.getLocation().getLine()));
    }

    private void printStep(TestStepFinished event) {
        if (event.getTestStep() instanceof PickleStepTestStep) {
            PickleStepTestStep testStep = (PickleStepTestStep)event.getTestStep();
            String keyword = testStep.getStep().getKeyword();
            String stepText = testStep.getStep().getText();
            String status = event.getResult().getStatus().name().toLowerCase(Locale.ROOT);
            String formattedStepText = this.formatStepText(keyword, stepText, this.formats.get(status), this.formats.get(status + "_arg"), testStep.getDefinitionArgument());
            String locationComment = this.formatLocationComment(event, testStep, keyword, stepText);
            this.out.println(STEP_INDENT + formattedStepText + locationComment);
            StepArgument stepArgument = testStep.getStep().getArgument();
            if (DataTableArgument.class.isInstance(stepArgument)) {
                DataTableFormatter tableFormatter = DataTableFormatter.builder().prefixRow(STEP_SCENARIO_INDENT).escapeDelimiters(false).build();
                DataTableArgument dataTableArgument = (DataTableArgument)stepArgument;
                try {
                    tableFormatter.formatTo(DataTable.create((List)dataTableArgument.cells()), (Appendable)this.out);
                }
                catch (IOException e) {
                    throw new CucumberException(e);
                }
            }
        }
    }

    private String formatLocationComment(TestStepFinished event, PickleStepTestStep testStep, String keyword, String stepText) {
        String codeLocation = testStep.getCodeLocation();
        if (codeLocation == null) {
            return SCENARIO_INDENT;
        }
        String locationIndent = this.calculateLocationIndent(event.getTestCase(), this.formatPlainStep(keyword, stepText));
        return locationIndent + this.formatLocation(codeLocation);
    }

    private void printError(TestStepFinished event) {
        Result result = event.getResult();
        this.printError(result);
    }

    private void printError(TestRunFinished event) {
        Result result = event.getResult();
        this.printError(result);
    }

    private void printError(Result result) {
        Throwable error = result.getError();
        if (error != null) {
            String name = result.getStatus().name().toLowerCase(Locale.ROOT);
            Format format = this.formats.get(name);
            String text = ExceptionUtils.printStackTrace(error);
            this.out.println("      " + format.text(text));
        }
    }

    private void printText(WriteEvent event) {
        StringBuilder builder = new StringBuilder();
        try (BufferedReader lines = new BufferedReader(new StringReader(event.getText()));){
            String line;
            while ((line = lines.readLine()) != null) {
                builder.append(String.format(STEP_SCENARIO_INDENT + line + "%n", new Object[0]));
            }
        }
        catch (IOException e) {
            throw new CucumberException(e);
        }
        this.out.append(builder);
    }

    private void printEmbedding(EmbedEvent event) {
        String line = "Embedding " + event.getName() + " [" + event.getMediaType() + " " + event.getData().length + " bytes]";
        this.out.println(STEP_SCENARIO_INDENT + line);
    }

    private String formatPlainStep(String keyword, String stepText) {
        return STEP_INDENT + keyword + stepText;
    }

    private String formatScenarioDefinition(TestCase testCase) {
        return testCase.getKeyword() + ": " + testCase.getName();
    }

    static URI relativize(URI uri) {
        if (!"file".equals(uri.getScheme())) {
            return uri;
        }
        if (!uri.isAbsolute()) {
            return uri;
        }
        try {
            URI root = new File(SCENARIO_INDENT).toURI();
            URI relative = root.relativize(uri);
            return new URI("file", relative.getSchemeSpecificPart(), relative.getFragment());
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException(e.getMessage(), e);
        }
    }

    private String calculateLocationIndent(TestCase testStep, String prefix) {
        Integer commentStartAt = this.commentStartIndex.getOrDefault(testStep.getId(), 0);
        int padding = commentStartAt - prefix.length();
        if (padding < 0) {
            return " ";
        }
        StringBuilder builder = new StringBuilder(padding);
        for (int i = 0; i < padding; ++i) {
            builder.append(" ");
        }
        return builder.toString();
    }

    private String formatLocation(String location) {
        return this.formats.get("comment").text("# " + location);
    }

    String formatStepText(String keyword, String stepText, Format textFormat, Format argFormat, List<Argument> arguments) {
        int beginIndex = 0;
        StringBuilder result = new StringBuilder(textFormat.text(keyword));
        for (Argument argument : arguments) {
            if (argument.getValue() != null) {
                int argumentOffset = argument.getStart();
                if (argumentOffset < beginIndex) continue;
                String text = stepText.substring(beginIndex, argumentOffset);
                result.append(textFormat.text(text));
            }
            if (argument.getValue() == null) continue;
            String text = stepText.substring(argument.getStart(), argument.getEnd());
            result.append(argFormat.text(text));
            beginIndex = argument.getEnd();
        }
        if (beginIndex != stepText.length()) {
            String text = stepText.substring(beginIndex);
            result.append(textFormat.text(text));
        }
        return result.toString();
    }

    public void setMonochrome(boolean monochrome) {
        this.formats = monochrome ? Formats.monochrome() : Formats.ansi();
    }
}

