/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.core.resource;

import io.cucumber.core.resource.ClasspathSupport;
import io.cucumber.core.resource.Resource;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.function.BiFunction;

class Resources {
    private Resources() {
    }

    static BiFunction<Path, Path, Resource> createPackageResource(String packageName) {
        return (baseDir, resource) -> new PackageResource((Path)baseDir, packageName, (Path)resource);
    }

    static BiFunction<Path, Path, Resource> createUriResource() {
        return (baseDir, resource) -> new UriResource((Path)resource);
    }

    static BiFunction<Path, Path, Resource> createClasspathRootResource() {
        return ClasspathResource::new;
    }

    static BiFunction<Path, Path, Resource> createClasspathResource(String classpathResourceName) {
        return (baseDir, resource) -> new ClasspathResource(classpathResourceName, (Path)baseDir, (Path)resource);
    }

    private static class ClasspathResource
    implements Resource {
        private final URI uri;
        private final Path resource;

        ClasspathResource(Path baseDir, Path resource) {
            this.uri = ClasspathSupport.classpathResourceUri(baseDir.relativize(resource));
            this.resource = resource;
        }

        ClasspathResource(String classpathResourceName, Path baseDir, Path resource) {
            this.uri = baseDir.equals(resource) ? ClasspathSupport.classpathResourceUri(classpathResourceName) : ClasspathSupport.determineClasspathResourceUri(baseDir, classpathResourceName, resource);
            this.resource = resource;
        }

        @Override
        public URI getUri() {
            return this.uri;
        }

        @Override
        public InputStream getInputStream() throws IOException {
            return Files.newInputStream(this.resource, new OpenOption[0]);
        }
    }

    private static class UriResource
    implements Resource {
        private final Path resource;

        UriResource(Path resource) {
            this.resource = resource;
        }

        @Override
        public URI getUri() {
            return this.resource.toUri();
        }

        @Override
        public InputStream getInputStream() throws IOException {
            return Files.newInputStream(this.resource, new OpenOption[0]);
        }
    }

    private static class PackageResource
    implements Resource {
        private final Path resource;
        private final URI uri;

        PackageResource(Path baseDir, String packageName, Path resource) {
            String classpathResourceName = ClasspathSupport.resourceNameOfPackageName(packageName);
            this.uri = ClasspathSupport.determineClasspathResourceUri(baseDir, classpathResourceName, resource);
            this.resource = resource;
        }

        @Override
        public URI getUri() {
            return this.uri;
        }

        @Override
        public InputStream getInputStream() throws IOException {
            return Files.newInputStream(this.resource, new OpenOption[0]);
        }
    }
}

