/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.core.snippets;

import io.cucumber.core.backend.Snippet;
import io.cucumber.core.gherkin.Argument;
import io.cucumber.core.gherkin.Step;
import io.cucumber.core.snippets.ArgumentPattern;
import io.cucumber.core.snippets.IdentifierGenerator;
import io.cucumber.core.snippets.SnippetType;
import io.cucumber.cucumberexpressions.CucumberExpressionGenerator;
import io.cucumber.cucumberexpressions.GeneratedExpression;
import io.cucumber.cucumberexpressions.ParameterType;
import io.cucumber.cucumberexpressions.ParameterTypeRegistry;
import io.cucumber.datatable.DataTable;
import io.cucumber.plugin.event.DataTableArgument;
import io.cucumber.plugin.event.DocStringArgument;
import java.lang.reflect.Type;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public final class SnippetGenerator {
    private static final ArgumentPattern DEFAULT_ARGUMENT_PATTERN = new ArgumentPattern(Pattern.compile("\\{.*?\\}"));
    private static final String REGEXP_HINT = "Write code here that turns the phrase above into concrete actions";
    private final Snippet snippet;
    private final CucumberExpressionGenerator generator;

    public SnippetGenerator(Snippet snippet, ParameterTypeRegistry parameterTypeRegistry) {
        this.snippet = snippet;
        this.generator = new CucumberExpressionGenerator(parameterTypeRegistry);
    }

    public List<String> getSnippet(Step step, SnippetType snippetType) {
        List generatedExpressions = this.generator.generateExpressions(step.getText());
        IdentifierGenerator functionNameGenerator = new IdentifierGenerator(snippetType.joiner());
        IdentifierGenerator parameterNameGenerator = new IdentifierGenerator(SnippetType.CAMELCASE.joiner());
        return generatedExpressions.stream().map(expression -> this.createSnippet(step, functionNameGenerator, parameterNameGenerator, (GeneratedExpression)expression)).collect(Collectors.toList());
    }

    private String createSnippet(Step step, IdentifierGenerator functionNameGenerator, IdentifierGenerator parameterNameGenerator, GeneratedExpression expression) {
        String keyword = step.getType().isGivenWhenThen() ? step.getKeyword() : step.getPreviousGivenWhenThenKeyword();
        String source = expression.getSource();
        String functionName = this.functionName(source, functionNameGenerator);
        List<String> parameterNames = this.toParameterNames(expression, parameterNameGenerator);
        Map<String, Type> arguments = this.arguments(step, parameterNames, expression.getParameterTypes());
        return this.snippet.template().format(new String[]{SnippetGenerator.sanitize(keyword), this.snippet.escapePattern(source), functionName, this.snippet.arguments(arguments), REGEXP_HINT, this.tableHint(step)});
    }

    private List<String> toParameterNames(GeneratedExpression expression, IdentifierGenerator parameterNameGenerator) {
        List parameterNames = expression.getParameterNames();
        return parameterNames.stream().map(parameterNameGenerator::generate).collect(Collectors.toList());
    }

    private static String sanitize(String keyWord) {
        return keyWord.replaceAll("[\\s',!]", "");
    }

    private String functionName(String sentence, IdentifierGenerator functionNameGenerator) {
        return Stream.of(sentence).map(DEFAULT_ARGUMENT_PATTERN::replaceMatchesWithSpace).map(functionNameGenerator::generate).filter(s -> !s.isEmpty()).findFirst().orElseGet(() -> functionNameGenerator.generate(sentence));
    }

    private Map<String, Type> arguments(Step step, List<String> parameterNames, List<ParameterType<?>> parameterTypes) {
        LinkedHashMap<String, Type> arguments = new LinkedHashMap<String, Type>(parameterTypes.size() + 1);
        for (int i = 0; i < parameterTypes.size(); ++i) {
            ParameterType<?> parameterType = parameterTypes.get(i);
            String parameterName = parameterNames.get(i);
            arguments.put(parameterName, parameterType.getType());
        }
        Argument arg = step.getArgument();
        if (arg == null) {
            return arguments;
        }
        if (arg instanceof DocStringArgument) {
            arguments.put(this.parameterName("docString", parameterNames), (Type)((Object)String.class));
        } else if (arg instanceof DataTableArgument) {
            arguments.put(this.parameterName("dataTable", parameterNames), (Type)((Object)DataTable.class));
        }
        return arguments;
    }

    private String tableHint(Step step) {
        if (step.getArgument() == null) {
            return "";
        }
        if (step.getArgument() instanceof DataTableArgument) {
            return this.snippet.tableHint();
        }
        return "";
    }

    private String parameterName(String name, List<String> parameterNames) {
        if (!parameterNames.contains(name)) {
            return name;
        }
        int i = 1;
        while (parameterNames.contains(name + i)) {
            ++i;
        }
        return name + i;
    }
}

