/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.core.plugin;

import io.cucumber.core.plugin.AnsiEscapes;
import io.cucumber.core.plugin.Format;
import java.util.HashMap;
import java.util.Map;

interface Formats {
    public Format get(String var1);

    public String up(int var1);

    public static Formats monochrome() {
        return new Monochrome();
    }

    public static Formats ansi() {
        return new Ansi();
    }

    public static final class Ansi
    implements Formats {
        private static final Map<String, Format> formats = new HashMap<String, Format>(){
            {
                this.put("undefined", Format.color(AnsiEscapes.YELLOW));
                this.put("undefined_arg", Format.color(AnsiEscapes.YELLOW, AnsiEscapes.INTENSITY_BOLD));
                this.put("unused", Format.color(AnsiEscapes.YELLOW));
                this.put("unused_arg", Format.color(AnsiEscapes.YELLOW, AnsiEscapes.INTENSITY_BOLD));
                this.put("pending", Format.color(AnsiEscapes.YELLOW));
                this.put("pending_arg", Format.color(AnsiEscapes.YELLOW, AnsiEscapes.INTENSITY_BOLD));
                this.put("executing", Format.color(AnsiEscapes.GREY));
                this.put("executing_arg", Format.color(AnsiEscapes.GREY, AnsiEscapes.INTENSITY_BOLD));
                this.put("failed", Format.color(AnsiEscapes.RED));
                this.put("failed_arg", Format.color(AnsiEscapes.RED, AnsiEscapes.INTENSITY_BOLD));
                this.put("ambiguous", Format.color(AnsiEscapes.RED));
                this.put("ambiguous_arg", Format.color(AnsiEscapes.RED, AnsiEscapes.INTENSITY_BOLD));
                this.put("passed", Format.color(AnsiEscapes.GREEN));
                this.put("passed_arg", Format.color(AnsiEscapes.GREEN, AnsiEscapes.INTENSITY_BOLD));
                this.put("outline", Format.color(AnsiEscapes.CYAN));
                this.put("outline_arg", Format.color(AnsiEscapes.CYAN, AnsiEscapes.INTENSITY_BOLD));
                this.put("skipped", Format.color(AnsiEscapes.CYAN));
                this.put("skipped_arg", Format.color(AnsiEscapes.CYAN, AnsiEscapes.INTENSITY_BOLD));
                this.put("comment", Format.color(AnsiEscapes.GREY));
                this.put("tag", Format.color(AnsiEscapes.CYAN));
                this.put("output", Format.color(AnsiEscapes.BLUE));
            }
        };

        private Ansi() {
        }

        @Override
        public Format get(String key) {
            Format format = formats.get(key);
            if (format == null) {
                throw new NullPointerException("No format for key " + key);
            }
            return format;
        }

        @Override
        public String up(int n) {
            return AnsiEscapes.up(n).toString();
        }
    }

    public static final class Monochrome
    implements Formats {
        private Monochrome() {
        }

        @Override
        public Format get(String key) {
            return text -> text;
        }

        @Override
        public String up(int n) {
            return "";
        }
    }
}

