/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.core.options;

import io.cucumber.core.backend.ObjectFactory;
import io.cucumber.core.feature.FeatureWithLines;
import io.cucumber.core.options.PluginOption;
import io.cucumber.core.order.PickleOrder;
import io.cucumber.core.order.StandardPickleOrders;
import io.cucumber.core.plugin.NoPublishFormatter;
import io.cucumber.core.plugin.Options;
import io.cucumber.core.plugin.PublishFormatter;
import io.cucumber.core.resource.ClasspathSupport;
import io.cucumber.core.snippets.SnippetType;
import io.cucumber.tagexpressions.Expression;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

public final class RuntimeOptions
implements io.cucumber.core.feature.Options,
io.cucumber.core.runner.Options,
Options,
io.cucumber.core.filter.Options,
io.cucumber.core.backend.Options {
    private final List<URI> glue = new ArrayList<URI>();
    private final List<Expression> tagExpressions = new ArrayList<Expression>();
    private final List<Pattern> nameFilters = new ArrayList<Pattern>();
    private final List<FeatureWithLines> featurePaths = new ArrayList<FeatureWithLines>();
    private final List<Options.Plugin> formatters = new ArrayList<Options.Plugin>();
    private final List<Options.Plugin> summaryPrinters = new ArrayList<Options.Plugin>();
    private boolean dryRun;
    private boolean monochrome = false;
    private boolean wip = false;
    private SnippetType snippetType = SnippetType.UNDERSCORE;
    private int threads = 1;
    private PickleOrder pickleOrder = StandardPickleOrders.lexicalUriOrder();
    private int count = 0;
    private Class<? extends ObjectFactory> objectFactoryClass;
    private String publishToken;
    private boolean publish;
    private boolean publishQuiet;
    private boolean enablePublishPlugin;

    private RuntimeOptions() {
    }

    public static RuntimeOptions defaultOptions() {
        return new RuntimeOptions();
    }

    void addDefaultFormatterIfAbsent() {
        if (this.formatters.isEmpty()) {
            this.formatters.add(PluginOption.parse("progress"));
        }
    }

    void addDefaultSummaryPrinterIfAbsent() {
        if (this.summaryPrinters.isEmpty()) {
            this.summaryPrinters.add(PluginOption.parse("default_summary"));
        }
    }

    void addDefaultGlueIfAbsent() {
        if (this.glue.isEmpty()) {
            this.glue.add(ClasspathSupport.rootPackageUri());
        }
    }

    void addDefaultFeaturePathIfAbsent() {
        if (this.featurePaths.isEmpty()) {
            this.featurePaths.add(FeatureWithLines.create(ClasspathSupport.rootPackageUri(), Collections.emptyList()));
        }
    }

    void addFormatters(List<Options.Plugin> formatters) {
        this.formatters.addAll(formatters);
    }

    void addSummaryPrinters(List<Options.Plugin> summaryPrinters) {
        this.summaryPrinters.addAll(summaryPrinters);
    }

    public boolean isMultiThreaded() {
        return this.getThreads() > 1;
    }

    public int getThreads() {
        return this.threads;
    }

    void setThreads(int threads) {
        this.threads = threads;
    }

    public List<Options.Plugin> plugins() {
        ArrayList<Options.Plugin> plugins = new ArrayList<Options.Plugin>();
        plugins.addAll(this.formatters);
        plugins.addAll(this.summaryPrinters);
        plugins.addAll(this.getPublishPlugin());
        return plugins;
    }

    private List<Options.Plugin> getPublishPlugin() {
        if (!this.enablePublishPlugin) {
            return Collections.emptyList();
        }
        if (this.publishToken != null) {
            return Collections.singletonList(PluginOption.forClass(PublishFormatter.class, this.publishToken));
        }
        if (this.publish) {
            return Collections.singletonList(PluginOption.forClass(PublishFormatter.class));
        }
        if (this.publishQuiet) {
            return Collections.emptyList();
        }
        return Collections.singletonList(PluginOption.forClass(NoPublishFormatter.class));
    }

    @Override
    public boolean isMonochrome() {
        return this.monochrome;
    }

    @Override
    public boolean isWip() {
        return this.wip;
    }

    void setWip(boolean wip) {
        this.wip = wip;
    }

    void setMonochrome(boolean monochrome) {
        this.monochrome = monochrome;
    }

    @Override
    public List<URI> getGlue() {
        return Collections.unmodifiableList(this.glue);
    }

    @Override
    public boolean isDryRun() {
        return this.dryRun;
    }

    @Override
    public SnippetType getSnippetType() {
        return this.snippetType;
    }

    @Override
    public Class<? extends ObjectFactory> getObjectFactoryClass() {
        return this.objectFactoryClass;
    }

    void setObjectFactoryClass(Class<? extends ObjectFactory> objectFactoryClass) {
        this.objectFactoryClass = objectFactoryClass;
    }

    void setSnippetType(SnippetType snippetType) {
        this.snippetType = snippetType;
    }

    void setDryRun(boolean dryRun) {
        this.dryRun = dryRun;
    }

    void setGlue(List<URI> parsedGlue) {
        this.glue.clear();
        this.glue.addAll(parsedGlue);
    }

    @Override
    public List<URI> getFeaturePaths() {
        return Collections.unmodifiableList(this.featurePaths.stream().map(FeatureWithLines::uri).sorted().distinct().collect(Collectors.toList()));
    }

    void setFeaturePaths(List<FeatureWithLines> featurePaths) {
        this.featurePaths.clear();
        this.featurePaths.addAll(featurePaths);
    }

    @Override
    public List<Expression> getTagExpressions() {
        return Collections.unmodifiableList(this.tagExpressions);
    }

    @Override
    public List<Pattern> getNameFilters() {
        return Collections.unmodifiableList(this.nameFilters);
    }

    void setNameFilters(List<Pattern> nameFilters) {
        this.nameFilters.clear();
        this.nameFilters.addAll(nameFilters);
    }

    @Override
    public Map<URI, Set<Integer>> getLineFilters() {
        HashMap lineFilters = new HashMap();
        this.featurePaths.forEach(featureWithLines -> {
            SortedSet<Integer> lines = featureWithLines.lines();
            URI uri = featureWithLines.uri();
            if (lines.isEmpty()) {
                return;
            }
            lineFilters.putIfAbsent(uri, new TreeSet());
            ((Set)lineFilters.get(uri)).addAll(lines);
        });
        return Collections.unmodifiableMap(lineFilters);
    }

    @Override
    public int getLimitCount() {
        return this.getCount();
    }

    public int getCount() {
        return this.count;
    }

    void setCount(int count) {
        this.count = count;
    }

    void setTagExpressions(List<Expression> tagExpressions) {
        this.tagExpressions.clear();
        this.tagExpressions.addAll(tagExpressions);
    }

    public PickleOrder getPickleOrder() {
        return this.pickleOrder;
    }

    void setPickleOrder(PickleOrder pickleOrder) {
        this.pickleOrder = pickleOrder;
    }

    void setPublishToken(String token) {
        this.publishToken = token;
    }

    void setPublish(boolean publish) {
        this.publish = publish;
    }

    void setPublishQuiet(boolean publishQuiet) {
        this.publishQuiet = publishQuiet;
    }

    void setEnablePublishPlugin(boolean enablePublishPlugin) {
        this.enablePublishPlugin = enablePublishPlugin;
    }
}

