/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.core.snippets;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

final class ArgumentPattern {
    private final Pattern pattern;
    private final String replacement;

    ArgumentPattern(Pattern pattern) {
        this(pattern, pattern.pattern());
    }

    private ArgumentPattern(Pattern pattern, String replacement) {
        this.pattern = pattern;
        this.replacement = replacement;
    }

    String replaceMatchesWithGroups(String name) {
        return this.replaceMatchWith(name, this.replacement);
    }

    private String replaceMatchWith(String name, String replacement) {
        Matcher matcher = this.pattern.matcher(name);
        String quotedReplacement = Matcher.quoteReplacement(replacement);
        return matcher.replaceAll(quotedReplacement);
    }

    String replaceMatchesWithSpace(String name) {
        return this.replaceMatchWith(name, " ");
    }
}

