/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.core.options;

import io.cucumber.core.logging.Logger;
import io.cucumber.core.logging.LoggerFactory;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;

public final class CucumberProperties {
    private static final Logger log = LoggerFactory.getLogger(CucumberProperties.class);

    private CucumberProperties() {
    }

    public static Map<String, String> create() {
        CucumberPropertiesMap fromBundle = new CucumberPropertiesMap(CucumberProperties.fromPropertiesFile());
        CucumberPropertiesMap fromEnvironmentProperties = new CucumberPropertiesMap(fromBundle, CucumberProperties.fromEnvironment());
        return new CucumberPropertiesMap(fromEnvironmentProperties, CucumberProperties.fromSystemProperties());
    }

    public static Map<String, String> fromPropertiesFile() {
        InputStream resourceAsStream = CucumberProperties.class.getResourceAsStream("/cucumber.properties");
        if (resourceAsStream == null) {
            log.debug(() -> "cucumber.properties file did not exist");
            return Collections.emptyMap();
        }
        try {
            Properties properties = new Properties();
            properties.load(resourceAsStream);
            return CucumberPropertiesMap.create(properties);
        }
        catch (IOException e) {
            log.error(e, () -> "cucumber.properties could not be loaded");
            throw new RuntimeException(e);
        }
    }

    public static Map<String, String> fromEnvironment() {
        Map<String, String> p = System.getenv();
        CucumberPropertiesMap properties = new CucumberPropertiesMap();
        properties.putAll(p);
        return properties;
    }

    public static Map<String, String> fromSystemProperties() {
        Properties p = System.getProperties();
        return CucumberPropertiesMap.create(p);
    }

    static class CucumberPropertiesMap
    extends HashMap<String, String> {
        private final CucumberPropertiesMap parent;

        CucumberPropertiesMap() {
            this((CucumberPropertiesMap)null);
        }

        CucumberPropertiesMap(CucumberPropertiesMap parent) {
            this(parent, Collections.emptyMap());
        }

        CucumberPropertiesMap(CucumberPropertiesMap parent, Map<String, String> properties) {
            super(properties);
            this.parent = parent;
        }

        CucumberPropertiesMap(Map<String, String> properties) {
            this(null, properties);
        }

        private static CucumberPropertiesMap create(Properties p) {
            CucumberPropertiesMap properties = new CucumberPropertiesMap();
            for (String key : p.stringPropertyNames()) {
                properties.put(key, p.getProperty(key));
            }
            return properties;
        }

        @Override
        public String get(Object key) {
            String exactMatch = (String)super.get(key);
            if (exactMatch != null) {
                return exactMatch;
            }
            if (!(key instanceof String)) {
                return null;
            }
            String keyString = (String)key;
            String uppercase = keyString.replace(".", "_").replace("-", "_").toUpperCase(Locale.ENGLISH);
            String upperCaseMatch = (String)super.get(uppercase);
            if (upperCaseMatch != null) {
                return upperCaseMatch;
            }
            String lowercase = keyString.replace(".", "_").replace("-", "_").toLowerCase(Locale.ENGLISH);
            String lowerValue = (String)super.get(lowercase);
            if (lowerValue != null) {
                return lowerValue;
            }
            if (this.parent == null) {
                return null;
            }
            return this.parent.get(key);
        }
    }
}

