/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.core.plugin;

import io.cucumber.core.plugin.UTF8OutputStreamWriter;
import io.cucumber.messages.Messages;
import io.cucumber.messages.internal.com.google.protobuf.MessageOrBuilder;
import io.cucumber.messages.internal.com.google.protobuf.util.JsonFormat;
import io.cucumber.plugin.ConcurrentEventListener;
import io.cucumber.plugin.event.EventPublisher;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;

public final class MessageFormatter
implements ConcurrentEventListener {
    private final Writer writer;
    private final JsonFormat.Printer jsonPrinter = JsonFormat.printer().omittingInsignificantWhitespace();

    public MessageFormatter(OutputStream outputStream) {
        this.writer = new UTF8OutputStreamWriter(outputStream);
    }

    public void setEventPublisher(EventPublisher publisher) {
        publisher.registerHandlerFor(Messages.Envelope.class, this::writeMessage);
    }

    private void writeMessage(Messages.Envelope envelope) {
        try {
            this.jsonPrinter.appendTo((MessageOrBuilder)envelope, (Appendable)this.writer);
            this.writer.write("\n");
            this.writer.flush();
            if (envelope.hasTestRunFinished()) {
                this.writer.close();
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

