/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.core.runtime;

import io.cucumber.core.backend.Backend;
import io.cucumber.core.backend.BackendProviderService;
import io.cucumber.core.backend.ObjectFactory;
import io.cucumber.core.exception.CucumberException;
import io.cucumber.core.runtime.BackendSupplier;
import io.cucumber.core.runtime.ObjectFactorySupplier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.ServiceLoader;
import java.util.function.Supplier;

public final class BackendServiceLoader
implements BackendSupplier {
    private final Supplier<ClassLoader> classLoaderSupplier;
    private final ObjectFactorySupplier objectFactorySupplier;

    public BackendServiceLoader(Supplier<ClassLoader> classLoaderSupplier, ObjectFactorySupplier objectFactorySupplier) {
        this.classLoaderSupplier = classLoaderSupplier;
        this.objectFactorySupplier = objectFactorySupplier;
    }

    @Override
    public Collection<? extends Backend> get() {
        return this.get(ServiceLoader.load(BackendProviderService.class));
    }

    Collection<? extends Backend> get(Iterable<BackendProviderService> serviceLoader) {
        Collection<? extends Backend> backends = this.loadBackends(serviceLoader);
        if (backends.isEmpty()) {
            throw new CucumberException("No backends were found. Please make sure you have a backend module on your CLASSPATH.");
        }
        return backends;
    }

    private Collection<? extends Backend> loadBackends(Iterable<BackendProviderService> serviceLoader) {
        ArrayList<Backend> backends = new ArrayList<Backend>();
        for (BackendProviderService backendProviderService : serviceLoader) {
            ObjectFactory objectFactory = this.objectFactorySupplier.get();
            backends.add(backendProviderService.create(objectFactory, objectFactory, this.classLoaderSupplier));
        }
        return backends;
    }
}

