/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.core.runtime;

import io.cucumber.core.backend.ObjectFactory;
import io.cucumber.core.backend.Options;
import io.cucumber.core.exception.CucumberException;
import java.lang.reflect.Constructor;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.ServiceLoader;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public final class ObjectFactoryServiceLoader {
    private final Options options;

    public ObjectFactoryServiceLoader(Options options) {
        this.options = Objects.requireNonNull(options);
    }

    ObjectFactory loadObjectFactory() {
        Class<? extends ObjectFactory> objectFactoryClass = this.options.getObjectFactoryClass();
        ServiceLoader<ObjectFactory> loader = ServiceLoader.load(ObjectFactory.class);
        if (objectFactoryClass == null) {
            return ObjectFactoryServiceLoader.loadSingleObjectFactoryOrDefault(loader);
        }
        return ObjectFactoryServiceLoader.loadSelectedObjectFactory(loader, objectFactoryClass);
    }

    private static ObjectFactory loadSelectedObjectFactory(ServiceLoader<ObjectFactory> loader, Class<? extends ObjectFactory> objectFactoryClass) {
        for (ObjectFactory objectFactory : loader) {
            if (!objectFactoryClass.equals(objectFactory.getClass())) continue;
            return objectFactory;
        }
        throw new CucumberException("Could not find object factory " + objectFactoryClass.getName() + ".\nCucumber uses SPI to discover object factory implementations.\nHas the class been registered with SPI and is it available on the classpath?");
    }

    private static ObjectFactory loadSingleObjectFactoryOrDefault(ServiceLoader<ObjectFactory> loader) {
        Iterator<ObjectFactory> objectFactories = loader.iterator();
        ObjectFactory objectFactory = objectFactories.hasNext() ? objectFactories.next() : new DefaultJavaObjectFactory();
        if (objectFactories.hasNext()) {
            ObjectFactory extraObjectFactory = objectFactories.next();
            throw new CucumberException(ObjectFactoryServiceLoader.getMultipleObjectFactoryLogMessage(objectFactory, extraObjectFactory));
        }
        return objectFactory;
    }

    private static String getMultipleObjectFactoryLogMessage(ObjectFactory ... objectFactories) {
        String factoryNames = Stream.of(objectFactories).map(Object::getClass).map(Class::getName).collect(Collectors.joining(", "));
        return "More than one Cucumber ObjectFactory was found in the classpath\n\nFound: " + factoryNames + "\n\nYou may have included, for instance, cucumber-spring AND cucumber-guice as part of\nyour dependencies. When this happens, Cucumber can't decide which to use.\nIn order to enjoy dependency injection features, either remove the unnecessary dependenciesfrom your classpath or use the `cucumber.object-factory` property or `@CucumberOptions(objectFactory=...)` to select one.\n";
    }

    static class DefaultJavaObjectFactory
    implements ObjectFactory {
        private final Map<Class<?>, Object> instances = new HashMap();

        DefaultJavaObjectFactory() {
        }

        @Override
        public void start() {
        }

        @Override
        public void stop() {
            this.instances.clear();
        }

        @Override
        public boolean addClass(Class<?> clazz) {
            return true;
        }

        @Override
        public <T> T getInstance(Class<T> type) {
            T instance = type.cast(this.instances.get(type));
            if (instance == null) {
                instance = this.cacheNewInstance(type);
            }
            return instance;
        }

        private <T> T cacheNewInstance(Class<T> type) {
            try {
                Constructor<T> constructor = type.getConstructor(new Class[0]);
                T instance = constructor.newInstance(new Object[0]);
                this.instances.put(type, instance);
                return instance;
            }
            catch (NoSuchMethodException e) {
                throw new CucumberException(String.format("%s doesn't have an empty constructor. If you need dependency injection, put cucumber-picocontainer on the classpath", type), e);
            }
            catch (Exception e) {
                throw new CucumberException(String.format("Failed to instantiate %s", type), e);
            }
        }
    }
}

