/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.core.options;

import io.cucumber.core.options.ShellWords;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public final class CurlOption {
    private final URI uri;
    private final HttpMethod method;
    private final List<Map.Entry<String, String>> headers;

    CurlOption(URI uri, HttpMethod method, List<Map.Entry<String, String>> headers) {
        this.uri = uri;
        this.method = method;
        this.headers = headers;
    }

    public static CurlOption parse(String cmdLine) {
        List<String> args = ShellWords.parse(cmdLine);
        String url = null;
        HttpMethod method = HttpMethod.PUT;
        ArrayList<Map.Entry<String, String>> headers = new ArrayList<Map.Entry<String, String>>();
        while (!args.isEmpty()) {
            String arg = args.remove(0);
            if (arg.equals("-X")) {
                String methodArg = CurlOption.removeArgFor(arg, args);
                method = HttpMethod.parse(methodArg);
                continue;
            }
            if (arg.equals("-H")) {
                String headerArg = CurlOption.removeArgFor(arg, args);
                AbstractMap.SimpleEntry<String, String> e = CurlOption.parseHeader(headerArg);
                headers.add(e);
                continue;
            }
            if (url != null) {
                throw new IllegalArgumentException("'" + cmdLine + "' was not a valid curl command");
            }
            url = arg;
        }
        if (url == null) {
            throw new IllegalArgumentException("'" + cmdLine + "' was not a valid curl command");
        }
        try {
            return new CurlOption(new URI(url), method, headers);
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException(e);
        }
    }

    private static AbstractMap.SimpleEntry<String, String> parseHeader(String headerArg) {
        String[] parts = headerArg.split(":", 2);
        if (parts.length != 2) {
            throw new IllegalArgumentException("'" + headerArg + "' was not a valid header");
        }
        return new AbstractMap.SimpleEntry<String, String>(parts[0].trim(), parts[1].trim());
    }

    private static String removeArgFor(String arg, List<String> args) {
        if (!args.isEmpty()) {
            return args.remove(0);
        }
        throw new IllegalArgumentException("Missing argument for " + arg);
    }

    public HttpMethod getMethod() {
        return this.method;
    }

    public List<Map.Entry<String, String>> getHeaders() {
        return this.headers;
    }

    public URI getUri() {
        return this.uri;
    }

    public static enum HttpMethod {
        GET,
        HEAD,
        POST,
        PUT,
        PATCH,
        DELETE,
        OPTIONS,
        TRACE;


        static HttpMethod parse(String argument) {
            for (HttpMethod value : HttpMethod.values()) {
                if (!value.name().equals(argument)) continue;
                return value;
            }
            throw new IllegalArgumentException(argument + " was not a http method");
        }
    }
}

