/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.core.filter;

import io.cucumber.core.gherkin.Pickle;
import java.net.URI;
import java.util.Collection;
import java.util.Map;
import java.util.function.Predicate;

final class LinePredicate
implements Predicate<Pickle> {
    private final Map<URI, ? extends Collection<Integer>> lineFilters;

    LinePredicate(Map<URI, ? extends Collection<Integer>> lineFilters) {
        this.lineFilters = lineFilters;
    }

    @Override
    public boolean test(Pickle pickle) {
        URI picklePath = pickle.getUri();
        if (!this.lineFilters.containsKey(picklePath)) {
            return true;
        }
        for (Integer line : this.lineFilters.get(picklePath)) {
            if (line.intValue() != pickle.getLocation().getLine() && line.intValue() != pickle.getLocation().getLine()) continue;
            return true;
        }
        return false;
    }
}

