/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.core.internal.gherkin.stream;

import io.cucumber.core.internal.gherkin.events.SourceEvent;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Iterator;
import java.util.List;

public class SourceEvents
implements Iterable<SourceEvent> {
    private final List<String> paths;

    public SourceEvents(List<String> paths) {
        this.paths = paths;
    }

    @Override
    public Iterator<SourceEvent> iterator() {
        final Iterator<String> pathIterator = this.paths.iterator();
        return new Iterator<SourceEvent>(){

            @Override
            public boolean hasNext() {
                return pathIterator.hasNext();
            }

            @Override
            public SourceEvent next() {
                try {
                    String path = (String)pathIterator.next();
                    String data = SourceEvents.read(new InputStreamReader((InputStream)new FileInputStream(path), "UTF-8"));
                    return new SourceEvent(path, data);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    private static String read(Reader reader) throws IOException {
        int read;
        char[] buffer = new char[65536];
        StringBuilder sb = new StringBuilder();
        do {
            if ((read = reader.read(buffer, 0, buffer.length)) <= 0) continue;
            sb.append(buffer, 0, read);
        } while (read >= 0);
        return sb.toString();
    }
}

