/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.core.runner;

import io.cucumber.core.exception.CucumberException;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;

class CamelCaseStringConverter {
    private static final String WHITESPACE = " ";
    private static final Pattern WHITESPACE_PATTERN = Pattern.compile("\\s+");

    CamelCaseStringConverter() {
    }

    private static CucumberException createDuplicateKeyException(String key, String conflictingKey, String newKey) {
        return new CucumberException(String.format("Failed to convert header '%s' to property name. '%s' also converted to '%s'", key, conflictingKey, newKey));
    }

    private static String toCamelCase(String string) {
        String[] parts = CamelCaseStringConverter.normalizeSpace(string).split(WHITESPACE);
        parts[0] = CamelCaseStringConverter.uncapitalize(parts[0]);
        for (int i = 1; i < parts.length; ++i) {
            parts[i] = CamelCaseStringConverter.capitalize(parts[i]);
        }
        return CamelCaseStringConverter.join(parts);
    }

    private static String join(String[] parts) {
        StringBuilder sb = new StringBuilder();
        for (String s : parts) {
            sb.append(s);
        }
        return sb.toString();
    }

    private static String normalizeSpace(String originalHeaderName) {
        return WHITESPACE_PATTERN.matcher(originalHeaderName.trim()).replaceAll(WHITESPACE);
    }

    private static String capitalize(String string) {
        return Character.toTitleCase(string.charAt(0)) + string.substring(1);
    }

    private static String uncapitalize(String string) {
        return Character.toLowerCase(string.charAt(0)) + string.substring(1);
    }

    Map<String, String> toCamelCase(Map<String, String> fromValue) {
        HashMap<String, String> map = new HashMap<String, String>();
        fromValue.keySet().forEach(key -> {
            String newKey = CamelCaseStringConverter.toCamelCase(key);
            String conflictingKey = (String)map.get(newKey);
            if (conflictingKey != null) {
                throw CamelCaseStringConverter.createDuplicateKeyException(key, conflictingKey, newKey);
            }
            map.put(newKey, (String)key);
        });
        map.replaceAll((newKey, oldKey) -> (String)fromValue.get(oldKey));
        return map;
    }
}

