/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.core.resource;

import io.cucumber.core.resource.ClasspathSupport;
import io.cucumber.core.resource.Resource;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.function.BiFunction;

class Resources {
    private Resources() {
    }

    static BiFunction<Path, Path, Resource> createPackageResource(String packageName) {
        return (baseDir, resource) -> new PackageResource((Path)baseDir, packageName, (Path)resource);
    }

    static BiFunction<Path, Path, Resource> createUriResource() {
        return (baseDir, resource) -> new UriResource((Path)resource);
    }

    static BiFunction<Path, Path, Resource> createClasspathRootResource() {
        return ClasspathResource::new;
    }

    static BiFunction<Path, Path, Resource> createClasspathResource(String classpathResourceName) {
        return (baseDir, resource) -> new ClasspathResource(classpathResourceName, (Path)baseDir, (Path)resource);
    }

    private static class PackageResource
    implements Resource {
        private final Path resource;
        private final URI uri;

        PackageResource(Path baseDir, String packageName, Path resource) {
            String packagePath = ClasspathSupport.packagePath(packageName);
            String fqn = ClasspathSupport.determineFullyQualifiedResourceName(baseDir, packagePath, resource);
            this.uri = URI.create("classpath:" + fqn);
            this.resource = resource;
        }

        @Override
        public URI getUri() {
            return this.uri;
        }

        @Override
        public InputStream getInputStream() throws IOException {
            return Files.newInputStream(this.resource, new OpenOption[0]);
        }
    }

    private static class UriResource
    implements Resource {
        private final Path resource;

        UriResource(Path resource) {
            this.resource = resource;
        }

        @Override
        public URI getUri() {
            return this.resource.toUri();
        }

        @Override
        public InputStream getInputStream() throws IOException {
            return Files.newInputStream(this.resource, new OpenOption[0]);
        }
    }

    private static class ClasspathResource
    implements Resource {
        private final URI uri;
        private final Path resource;

        ClasspathResource(Path baseDir, Path resource) {
            this.uri = URI.create("classpath:" + baseDir.relativize(resource).toString());
            this.resource = resource;
        }

        ClasspathResource(String classpathResourceName, Path baseDir, Path resource) {
            if (baseDir.equals(resource)) {
                this.uri = URI.create("classpath:" + classpathResourceName);
            } else {
                String fqn = ClasspathSupport.determineFullyQualifiedResourceName(baseDir, classpathResourceName, resource);
                this.uri = URI.create("classpath:" + fqn);
            }
            this.resource = resource;
        }

        @Override
        public URI getUri() {
            return this.uri;
        }

        @Override
        public InputStream getInputStream() throws IOException {
            return Files.newInputStream(this.resource, new OpenOption[0]);
        }
    }
}

