/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.core.resource;

import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.List;
import java.util.Objects;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.lang.model.SourceVersion;

public final class ClasspathSupport {
    public static final String CLASSPATH_SCHEME = "classpath";
    public static final String CLASSPATH_SCHEME_PREFIX = "classpath:";
    static final String DEFAULT_PACKAGE_NAME = "";
    private static final String CLASS_FILE_SUFFIX = ".class";
    public static final char RESOURCE_SEPARATOR_CHAR = '/';
    public static final String RESOURCE_SEPARATOR_STRING = String.valueOf('/');
    private static final char PACKAGE_SEPARATOR_CHAR = '.';
    public static final String PACKAGE_SEPARATOR_STRING = String.valueOf('.');
    private static final Pattern DOT_PATTERN = Pattern.compile("\\.");

    private ClasspathSupport() {
    }

    static void requireValidPackageName(String packageName) {
        Objects.requireNonNull(packageName, "packageName must not be null");
        if (packageName.equals(DEFAULT_PACKAGE_NAME)) {
            return;
        }
        boolean valid = Arrays.stream(DOT_PATTERN.split(packageName, -1)).allMatch(SourceVersion::isName);
        if (!valid) {
            throw new IllegalArgumentException("Invalid part(s) in package name: " + packageName);
        }
    }

    static List<URI> getUrisForResource(ClassLoader classLoader, String resourceName) {
        try {
            Enumeration<URL> resources = classLoader.getResources(resourceName);
            ArrayList<URI> uris = new ArrayList<URI>();
            while (resources.hasMoreElements()) {
                URL resource = resources.nextElement();
                uris.add(resource.toURI());
            }
            return uris;
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e);
        }
    }

    static List<URI> getRootUrisForPackage(ClassLoader classLoader, String basePackageName) {
        return ClasspathSupport.getUrisForResource(classLoader, ClasspathSupport.packagePath(basePackageName));
    }

    public static String packagePath(String packageName) {
        return packageName.replace('.', '/');
    }

    public static String resourcePath(URI resourceUri) {
        if (!CLASSPATH_SCHEME.equals(resourceUri.getScheme())) {
            throw new IllegalArgumentException("uri must have classpath scheme " + resourceUri);
        }
        String resourcePath = resourceUri.getSchemeSpecificPart();
        if (resourcePath.startsWith(RESOURCE_SEPARATOR_STRING)) {
            return resourcePath.substring(1);
        }
        return resourcePath;
    }

    static String determinePackageName(Path baseDir, String basePackageName, Path classFile) {
        String subPackageName = ClasspathSupport.determineSubpackageName(baseDir, classFile);
        return Stream.of(basePackageName, subPackageName).filter(value -> !value.isEmpty()).collect(Collectors.joining(PACKAGE_SEPARATOR_STRING));
    }

    private static String determineSubpackageResourceName(Path baseDir, Path resource) {
        Path relativePath = baseDir.relativize(resource.getParent());
        return relativePath.toString();
    }

    static String determineFullyQualifiedResourceName(Path baseDir, String packagePath, Path resource) {
        String subPackageName = ClasspathSupport.determineSubpackageResourceName(baseDir, resource);
        String resourceName = resource.getFileName().toString();
        return Stream.of(packagePath, subPackageName, resourceName).filter(value -> !value.isEmpty()).collect(Collectors.joining(RESOURCE_SEPARATOR_STRING));
    }

    private static String determineSubpackageName(Path baseDir, Path classFile) {
        Path relativePath = baseDir.relativize(classFile.getParent());
        String pathSeparator = baseDir.getFileSystem().getSeparator();
        return relativePath.toString().replace(pathSeparator, PACKAGE_SEPARATOR_STRING);
    }

    static String determineFullyQualifiedClassName(Path baseDir, String basePackageName, Path classFile) {
        String subPackageName = ClasspathSupport.determineSubpackageName(baseDir, classFile);
        String simpleClassName = ClasspathSupport.determineSimpleClassName(classFile);
        return Stream.of(basePackageName, subPackageName, simpleClassName).filter(value -> !value.isEmpty()).collect(Collectors.joining(PACKAGE_SEPARATOR_STRING));
    }

    private static String determineSimpleClassName(Path classFile) {
        String fileName = classFile.getFileName().toString();
        return fileName.substring(0, fileName.length() - CLASS_FILE_SUFFIX.length());
    }

    public static String packageNameOfResource(String classpathResourceName) {
        Path parent = Paths.get(classpathResourceName, new String[0]).getParent();
        if (parent == null) {
            return DEFAULT_PACKAGE_NAME;
        }
        String packagePath = parent.toString();
        return ClasspathSupport.resourceName(packagePath);
    }

    public static String resourceName(String resourcePath) {
        return resourcePath.replace('/', '.');
    }

    public static URI rootPackage() {
        try {
            return new URI(CLASSPATH_SCHEME, RESOURCE_SEPARATOR_STRING, null);
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException(e);
        }
    }
}

