/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.core.runner;

import io.cucumber.core.backend.CucumberBackendException;
import io.cucumber.core.backend.CucumberInvocationTargetException;
import io.cucumber.core.backend.TestCaseState;
import io.cucumber.core.exception.CucumberException;
import io.cucumber.core.runner.CoreHookDefinition;
import io.cucumber.core.runner.StackManipulation;
import io.cucumber.core.runner.StepDefinitionMatch;

final class HookDefinitionMatch
implements StepDefinitionMatch {
    private final CoreHookDefinition hookDefinition;

    HookDefinitionMatch(CoreHookDefinition hookDefinition) {
        this.hookDefinition = hookDefinition;
    }

    @Override
    public void runStep(TestCaseState state) throws Throwable {
        try {
            this.hookDefinition.execute(state);
        }
        catch (CucumberBackendException e) {
            throw this.couldNotInvokeHook(e);
        }
        catch (CucumberInvocationTargetException e) {
            throw StackManipulation.removeFrameworkFrames(e);
        }
    }

    private Throwable couldNotInvokeHook(CucumberBackendException e) {
        return new CucumberException(String.format("Could not invoke hook defined at '%s'.\nIt appears there was a problem with the hook definition.\nThe details are in the stacktrace below.", this.hookDefinition.getLocation()), e);
    }

    @Override
    public void dryRunStep(TestCaseState state) {
    }

    @Override
    public String getCodeLocation() {
        return this.hookDefinition.getLocation();
    }
}

