/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.core.model;

import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Locale;
import java.util.Objects;

public class FeaturePath {
    private FeaturePath() {
    }

    public static URI parse(String featureIdentifier) {
        Objects.requireNonNull(featureIdentifier, "featureIdentifier may not be null");
        if (featureIdentifier.isEmpty()) {
            throw new IllegalArgumentException("featureIdentifier may not be empty");
        }
        if ("classpath:".equals(featureIdentifier)) {
            return FeaturePath.rootPackage();
        }
        if (FeaturePath.nonStandardPathSeparatorInUse(featureIdentifier)) {
            String standardized = FeaturePath.replaceNonStandardPathSeparator(featureIdentifier);
            return FeaturePath.parseAssumeFileScheme(standardized);
        }
        if (FeaturePath.isWindowsOS() && FeaturePath.pathContainsWindowsDrivePattern(featureIdentifier)) {
            return FeaturePath.parseAssumeFileScheme(featureIdentifier);
        }
        if (FeaturePath.probablyURI(featureIdentifier)) {
            return FeaturePath.parseProbableURI(featureIdentifier);
        }
        return FeaturePath.parseAssumeFileScheme(featureIdentifier);
    }

    private static URI rootPackage() {
        try {
            return new URI("classpath", "/", null);
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException(e);
        }
    }

    private static URI parseProbableURI(String featureIdentifier) {
        return URI.create(featureIdentifier);
    }

    private static boolean isWindowsOS() {
        String osName = System.getProperty("os.name");
        return FeaturePath.normalize(osName).contains("windows");
    }

    private static boolean pathContainsWindowsDrivePattern(String featureIdentifier) {
        return featureIdentifier.matches("^[a-zA-Z]:.*$");
    }

    private static boolean probablyURI(String featureIdentifier) {
        return featureIdentifier.matches("^[a-zA-Z+.\\-]+:.*$");
    }

    private static String replaceNonStandardPathSeparator(String featureIdentifier) {
        return featureIdentifier.replace(File.separatorChar, '/');
    }

    private static boolean nonStandardPathSeparatorInUse(String featureIdentifier) {
        return File.separatorChar != '/' && featureIdentifier.contains(File.separator);
    }

    private static URI parseAssumeFileScheme(String featureIdentifier) {
        File featureFile = new File(featureIdentifier);
        if (featureFile.isAbsolute()) {
            return featureFile.toURI();
        }
        try {
            URI root = new File("").toURI();
            URI relative = root.relativize(featureFile.toURI());
            return new URI("file", relative.getSchemeSpecificPart(), relative.getFragment());
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException(e.getMessage(), e);
        }
    }

    private static String normalize(String value) {
        if (value == null) {
            return "";
        }
        return value.toLowerCase(Locale.US).replaceAll("[^a-z0-9]+", "");
    }
}

