/*
 * Decompiled with CFR 0.152.
 */
package cucumber.runtime.io;

import cucumber.runtime.io.FileResource;
import cucumber.runtime.io.FlatteningIterator;
import cucumber.runtime.io.Helpers;
import cucumber.runtime.io.Resource;
import java.io.File;
import java.io.FileFilter;
import java.util.Arrays;
import java.util.Iterator;

class FileResourceIterator
implements Iterator<Resource> {
    private final FlatteningIterator<Resource> flatteningIterator = new FlatteningIterator();

    static FileResourceIterator createFileResourceIterator(File root, File file, String suffix) {
        return new FileResourceIterator(root, file, suffix, false);
    }

    static FileResourceIterator createClasspathFileResourceIterator(File classpathRoot, File file, String suffix) {
        return new FileResourceIterator(classpathRoot, file, suffix, true);
    }

    private FileResourceIterator(File root, File file, final String suffix, boolean classpathFileResourceIterator) {
        FileFilter filter = new FileFilter(){

            @Override
            public boolean accept(File file) {
                return file.isDirectory() || Helpers.hasSuffix(suffix, file.getPath());
            }
        };
        this.flatteningIterator.push(new FileIterator(root, file, filter, classpathFileResourceIterator));
    }

    @Override
    public boolean hasNext() {
        return this.flatteningIterator.hasNext();
    }

    @Override
    public Resource next() {
        return this.flatteningIterator.next();
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    private static class FileIterator
    implements Iterator<Object> {
        private final Iterator<File> files;
        private final FileFilter filter;
        private final File root;
        private final boolean classpathFileIterator;

        FileIterator(File root, File file, FileFilter filter, boolean classpathFileIterator) {
            this.root = root;
            if (file.isDirectory()) {
                this.files = Arrays.asList(file.listFiles(filter)).iterator();
            } else if (file.isFile()) {
                this.files = Arrays.asList(file).iterator();
            } else {
                throw new IllegalArgumentException("Not a file or directory: " + file.getAbsolutePath());
            }
            this.filter = filter;
            this.classpathFileIterator = classpathFileIterator;
        }

        @Override
        public Object next() {
            File next = this.files.next();
            if (next.isDirectory()) {
                return new FileIterator(this.root, next, this.filter, this.classpathFileIterator);
            }
            return this.createFileResource(next);
        }

        @Override
        public boolean hasNext() {
            return this.files.hasNext();
        }

        @Override
        public void remove() {
            this.files.remove();
        }

        private FileResource createFileResource(File next) {
            if (this.classpathFileIterator) {
                return FileResource.createClasspathFileResource(this.root, next);
            }
            return FileResource.createFileResource(this.root, next);
        }
    }
}

