/*
 * Decompiled with CFR 0.152.
 */
package cucumber.runtime.formatter;

import cucumber.api.TestCase;
import cucumber.api.event.EventHandler;
import cucumber.api.event.EventListener;
import cucumber.api.event.EventPublisher;
import cucumber.api.event.TestCaseFinished;
import cucumber.api.event.TestRunFinished;
import cucumber.api.formatter.NiceAppendable;
import cucumber.api.formatter.StrictAware;
import io.cucumber.core.model.FeatureWithLines;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

final class RerunFormatter
implements EventListener,
StrictAware {
    private final NiceAppendable out;
    private final Map<String, Collection<Integer>> featureAndFailedLinesMapping = new HashMap<String, Collection<Integer>>();
    private final EventHandler<TestRunFinished> runFinishHandler = new EventHandler<TestRunFinished>(){

        @Override
        public void receive(TestRunFinished event) {
            for (Map.Entry entry : RerunFormatter.this.featureAndFailedLinesMapping.entrySet()) {
                FeatureWithLines featureWithLines = FeatureWithLines.parse((String)entry.getKey(), (Collection)entry.getValue());
                RerunFormatter.this.out.println(featureWithLines.toString());
            }
            RerunFormatter.this.out.close();
        }
    };
    private boolean isStrict = false;
    private final EventHandler<TestCaseFinished> testCaseFinishedHandler = new EventHandler<TestCaseFinished>(){

        @Override
        public void receive(TestCaseFinished event) {
            if (!event.result.isOk(RerunFormatter.this.isStrict)) {
                this.recordTestFailed(event.testCase);
            }
        }

        private void recordTestFailed(TestCase testCase) {
            String uri = testCase.getUri();
            Collection<Integer> failedTestCaseLines = this.getFailedTestCaseLines(uri);
            failedTestCaseLines.add(testCase.getLine());
        }

        private Collection<Integer> getFailedTestCaseLines(String uri) {
            ArrayList failedTestCases = (ArrayList)RerunFormatter.this.featureAndFailedLinesMapping.get(uri);
            if (failedTestCases == null) {
                failedTestCases = new ArrayList();
                RerunFormatter.this.featureAndFailedLinesMapping.put(uri, failedTestCases);
            }
            return failedTestCases;
        }
    };

    public RerunFormatter(Appendable out) {
        this.out = new NiceAppendable(out);
    }

    @Override
    public void setEventPublisher(EventPublisher publisher) {
        publisher.registerHandlerFor(TestCaseFinished.class, this.testCaseFinishedHandler);
        publisher.registerHandlerFor(TestRunFinished.class, this.runFinishHandler);
    }

    @Override
    public void setStrict(boolean strict) {
        this.isStrict = strict;
    }
}

