/*
 * Decompiled with CFR 0.152.
 */
package cucumber.runtime.formatter;

import cucumber.api.Plugin;
import cucumber.api.StepDefinitionReporter;
import cucumber.api.event.ConcurrentEventListener;
import cucumber.api.event.Event;
import cucumber.api.event.EventHandler;
import cucumber.api.event.EventListener;
import cucumber.api.event.EventPublisher;
import cucumber.api.formatter.ColorAware;
import cucumber.api.formatter.StrictAware;
import cucumber.runner.CanonicalOrderEventPublisher;
import cucumber.runtime.Utils;
import cucumber.runtime.formatter.PluginFactory;
import io.cucumber.core.options.PluginOptions;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.List;

public final class Plugins {
    private final List<Plugin> plugins;
    private final ClassLoader classLoader;
    private boolean pluginNamesInstantiated;
    private final PluginFactory pluginFactory;
    private EventPublisher orderedEventPublisher;
    private final PluginOptions pluginOptions;

    public Plugins(ClassLoader classLoader, PluginFactory pluginFactory, PluginOptions pluginOptions) {
        this.classLoader = classLoader;
        this.pluginFactory = pluginFactory;
        this.pluginOptions = pluginOptions;
        this.plugins = this.createPlugins();
    }

    private EventPublisher getOrderedEventPublisher(EventPublisher eventPublisher) {
        if (this.orderedEventPublisher == null) {
            this.orderedEventPublisher = Plugins.createCanonicalOrderEventPublisher(eventPublisher);
        }
        return this.orderedEventPublisher;
    }

    private static EventPublisher createCanonicalOrderEventPublisher(EventPublisher eventPublisher) {
        final CanonicalOrderEventPublisher canonicalOrderEventPublisher = new CanonicalOrderEventPublisher();
        eventPublisher.registerHandlerFor(Event.class, new EventHandler<Event>(){

            @Override
            public void receive(Event event) {
                canonicalOrderEventPublisher.handle(event);
            }
        });
        return canonicalOrderEventPublisher;
    }

    private List<Plugin> createPlugins() {
        ArrayList<Plugin> plugins = new ArrayList<Plugin>();
        if (!this.pluginNamesInstantiated) {
            for (String pluginName : this.pluginOptions.getPluginNames()) {
                Plugin plugin = this.pluginFactory.create(pluginName);
                this.addPlugin(plugins, plugin);
            }
            this.pluginNamesInstantiated = true;
        }
        return plugins;
    }

    public List<Plugin> getPlugins() {
        return this.plugins;
    }

    public StepDefinitionReporter stepDefinitionReporter() {
        return this.pluginProxy(StepDefinitionReporter.class);
    }

    public void addPlugin(Plugin plugin) {
        this.addPlugin(this.plugins, plugin);
    }

    private void addPlugin(List<Plugin> plugins, Plugin plugin) {
        plugins.add(plugin);
        this.setMonochromeOnColorAwarePlugins(plugin);
        this.setStrictOnStrictAwarePlugins(plugin);
    }

    private void setMonochromeOnColorAwarePlugins(Plugin plugin) {
        if (plugin instanceof ColorAware) {
            ColorAware colorAware = (ColorAware)plugin;
            colorAware.setMonochrome(this.pluginOptions.isMonochrome());
        }
    }

    private void setStrictOnStrictAwarePlugins(Plugin plugin) {
        if (plugin instanceof StrictAware) {
            StrictAware strictAware = (StrictAware)plugin;
            strictAware.setStrict(this.pluginOptions.isStrict());
        }
    }

    public void setEventBusOnEventListenerPlugins(EventPublisher eventPublisher) {
        for (Plugin plugin : this.plugins) {
            if (plugin instanceof ConcurrentEventListener) {
                ((ConcurrentEventListener)plugin).setEventPublisher(eventPublisher);
                continue;
            }
            if (!(plugin instanceof EventListener)) continue;
            ((EventListener)plugin).setEventPublisher(eventPublisher);
        }
    }

    public void setSerialEventBusOnEventListenerPlugins(EventPublisher eventPublisher) {
        for (Plugin plugin : this.plugins) {
            if (plugin instanceof ConcurrentEventListener) {
                ((ConcurrentEventListener)plugin).setEventPublisher(eventPublisher);
                continue;
            }
            if (!(plugin instanceof EventListener)) continue;
            EventPublisher orderedEventPublisher = this.getOrderedEventPublisher(eventPublisher);
            ((EventListener)plugin).setEventPublisher(orderedEventPublisher);
        }
    }

    private <T> T pluginProxy(final Class<T> type) {
        Object proxy = Proxy.newProxyInstance(this.classLoader, new Class[]{type}, new InvocationHandler(){

            @Override
            public Object invoke(Object target, Method method, Object[] args) throws Throwable {
                for (Plugin plugin : Plugins.this.getPlugins()) {
                    if (!type.isInstance(plugin)) continue;
                    try {
                        Utils.invoke(plugin, method, 0L, args);
                    }
                    catch (Throwable t) {
                        if (method.getName().equals("startOfScenarioLifeCycle") || method.getName().equals("endOfScenarioLifeCycle")) continue;
                        throw t;
                    }
                }
                return null;
            }
        });
        return type.cast(proxy);
    }
}

