/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.junit;

import android.os.Bundle;
import android.util.Log;
import io.cucumber.junit.Arguments;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public class CoverageDumper {
    private static final String RESULT_KEY_COVERAGE_PATH = "coverageFilePath";
    private static final String RESULT_STREAM_SUCCESS_OUTPUT_FORMAT = "Generated code coverage data to %s";
    private static final String LOG_ERROR_OUTPUT = "Failed to generate coverage.";
    private static final String RESULT_STREAM_ERROR_OUTPUT = "Error: Failed to generate coverage. Check logcat for details.";
    private static final String IMPLEMENTATION_CLASS = "com.vladium.emma.rt.RT";
    private static final String IMPLEMENTATION_METHOD = "dumpCoverageData";
    private final Arguments arguments;

    public CoverageDumper(Arguments arguments) {
        this.arguments = arguments;
    }

    public void requestDump(Bundle bundle) {
        if (!this.arguments.isCoverageEnabled()) {
            return;
        }
        String coverageDateFilePath = this.arguments.coverageDataFilePath();
        File coverageFile = new File(coverageDateFilePath);
        try {
            Class<?> dumperClass = Class.forName(IMPLEMENTATION_CLASS);
            Method dumperMethod = dumperClass.getMethod(IMPLEMENTATION_METHOD, coverageFile.getClass(), Boolean.TYPE, Boolean.TYPE);
            dumperMethod.invoke(null, coverageFile, false, false);
            bundle.putString(RESULT_KEY_COVERAGE_PATH, coverageDateFilePath);
            this.appendNewLineToResultStream(bundle, String.format(RESULT_STREAM_SUCCESS_OUTPUT_FORMAT, coverageDateFilePath));
        }
        catch (ClassNotFoundException e) {
            this.reportError(bundle, e);
        }
        catch (SecurityException e) {
            this.reportError(bundle, e);
        }
        catch (NoSuchMethodException e) {
            this.reportError(bundle, e);
        }
        catch (IllegalAccessException e) {
            this.reportError(bundle, e);
        }
        catch (InvocationTargetException e) {
            this.reportError(bundle, e);
        }
    }

    private void reportError(Bundle results, Exception e) {
        Log.e((String)"cucumber-android", (String)LOG_ERROR_OUTPUT, (Throwable)e);
        this.appendNewLineToResultStream(results, RESULT_STREAM_ERROR_OUTPUT);
    }

    private void appendNewLineToResultStream(Bundle results, String message) {
        String currentStream = results.getString("stream");
        results.putString("stream", currentStream + "\n" + message);
    }
}

