/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.junit;

import android.content.Context;
import android.content.res.AssetManager;
import cucumber.runtime.CucumberException;
import cucumber.runtime.io.Resource;
import cucumber.runtime.io.ResourceLoader;
import io.cucumber.junit.AndroidResource;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;

final class AndroidResourceLoader
implements ResourceLoader {
    private static final String RESOURCE_PATH_FORMAT = "%s/%s";
    private final Context context;

    AndroidResourceLoader(Context context) {
        this.context = context;
    }

    public Iterable<Resource> resources(URI path, String suffix) {
        try {
            ArrayList<Resource> resources = new ArrayList<Resource>();
            AssetManager assetManager = this.context.getAssets();
            this.addResourceRecursive(resources, assetManager, path, suffix);
            return resources;
        }
        catch (IOException e) {
            throw new CucumberException("Error loading resources from " + path + " with suffix " + suffix, (Throwable)e);
        }
    }

    private void addResourceRecursive(List<Resource> resources, AssetManager assetManager, URI path, String suffix) throws IOException {
        String schemeSpecificPart = path.getSchemeSpecificPart();
        if (schemeSpecificPart.endsWith(suffix)) {
            resources.add(new AndroidResource(this.context, path));
            return;
        }
        String[] list = assetManager.list(schemeSpecificPart);
        if (list != null) {
            for (String name : list) {
                String subPath = String.format(RESOURCE_PATH_FORMAT, path.toString(), name);
                this.addResourceRecursive(resources, assetManager, URI.create(subPath), suffix);
            }
        }
    }
}

