/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.cienvironment;

import io.cucumber.cienvironment.CiEnvironment;
import io.cucumber.cienvironment.RemoveUserInfo;
import io.cucumber.cienvironment.VariableExpression;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;

final class CiEnvironmentImpl
implements CiEnvironment {
    public String name;
    public String url;
    public String buildNumber;
    public Git git;

    CiEnvironmentImpl() {
    }

    CiEnvironmentImpl(String name, String url, String buildNumber, Git git) {
        this.name = Objects.requireNonNull(name);
        this.url = Objects.requireNonNull(url);
        this.buildNumber = buildNumber;
        this.git = git;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getUrl() {
        return this.url;
    }

    @Override
    public Optional<String> getBuildNumber() {
        return Optional.ofNullable(this.buildNumber);
    }

    @Override
    public Optional<CiEnvironment.Git> getGit() {
        return Optional.ofNullable(this.git);
    }

    Optional<CiEnvironment> detect(Map<String, String> env, Function<Path, Stream<String>> getLines) {
        String url = VariableExpression.evaluate(this.getUrl(), env);
        if (url == null) {
            return Optional.empty();
        }
        return Optional.of(new CiEnvironmentImpl(this.name, url, VariableExpression.evaluate(this.getBuildNumber().orElse(null), env), this.detectGit(env, getLines)));
    }

    private Git detectGit(Map<String, String> env, Function<Path, Stream<String>> getLines) {
        String revision = this.evaluateRevision(env, getLines);
        if (revision == null) {
            return null;
        }
        String remote = VariableExpression.evaluate(this.git.remote, env);
        if (remote == null) {
            return null;
        }
        return new Git(RemoveUserInfo.fromUrl(remote), revision, VariableExpression.evaluate(this.git.branch, env), VariableExpression.evaluate(this.git.tag, env));
    }

    private String evaluateRevision(Map<String, String> env, Function<Path, Stream<String>> getLines) {
        if ("pull_request".equals(env.get("GITHUB_EVENT_NAME"))) {
            if (env.get("GITHUB_EVENT_PATH") == null) {
                throw new RuntimeException("GITHUB_EVENT_PATH not set");
            }
            Path path = Paths.get(env.get("GITHUB_EVENT_PATH"), new String[0]);
            return CiEnvironmentImpl.getJsonProperty(path, getLines, "after");
        }
        return VariableExpression.evaluate(this.git.revision, env);
    }

    static String getJsonProperty(Path path, Function<Path, Stream<String>> getLines, String property) {
        Pattern pattern = Pattern.compile(".*\"" + property + "\"\\s*:\\s*\"([^\"]+)\".*");
        return getLines.apply(path).filter(line -> pattern.matcher(line.trim()).matches()).findFirst().map(line -> {
            Matcher matcher = pattern.matcher(line.trim());
            return matcher.matches() ? matcher.group(1) : null;
        }).orElseThrow(() -> {
            String json = ((Stream)getLines.apply(path)).collect(Collectors.joining(""));
            return new RuntimeException(String.format("No after property in %s:\n%s", path, json));
        });
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CiEnvironmentImpl that = (CiEnvironmentImpl)o;
        return Objects.equals(this.name, that.name) && Objects.equals(this.url, that.url) && Objects.equals(this.buildNumber, that.buildNumber) && Objects.equals(this.git, that.git);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.url, this.buildNumber, this.git);
    }

    public String toString() {
        return "CiEnvironmentImpl{name='" + this.name + '\'' + ", url='" + this.url + '\'' + ", buildNumber='" + this.buildNumber + '\'' + ", git=" + this.git + '}';
    }

    static final class Git
    implements CiEnvironment.Git {
        public String remote;
        public String revision;
        public String branch;
        public String tag;

        Git() {
        }

        Git(String remote, String revision, String branch, String tag) {
            this.remote = Objects.requireNonNull(remote);
            this.revision = Objects.requireNonNull(revision);
            this.branch = branch;
            this.tag = tag;
        }

        @Override
        public String getRemote() {
            return this.remote;
        }

        @Override
        public String getRevision() {
            return this.revision;
        }

        @Override
        public Optional<String> getBranch() {
            return Optional.ofNullable(this.branch);
        }

        @Override
        public Optional<String> getTag() {
            return Optional.ofNullable(this.tag);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Git git = (Git)o;
            return Objects.equals(this.remote, git.remote) && Objects.equals(this.revision, git.revision) && Objects.equals(this.branch, git.branch) && Objects.equals(this.tag, git.tag);
        }

        public int hashCode() {
            return Objects.hash(this.remote, this.revision, this.branch, this.tag);
        }

        public String toString() {
            return "Git{remote='" + this.remote + '\'' + ", revision='" + this.revision + '\'' + ", branch='" + this.branch + '\'' + ", tag='" + this.tag + '\'' + '}';
        }
    }
}

