/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.cienvironment;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jspecify.annotations.Nullable;

final class GithubEventParser {
    private static final Pattern GITHUB_EVENT_PATTERN = Pattern.compile("^\\{.*?\"pull_request\" *: *\\{.*?\"head\" *: *\\{.*?\"sha\" *: *\"([a-z0-9]+)\".*}.*}.*}$");

    private GithubEventParser() {
    }

    static @Nullable String evaluateRevisionGithub(Map<String, String> env) {
        if (!"pull_request".equals(env.get("GITHUB_EVENT_NAME"))) {
            return null;
        }
        String path = env.get("GITHUB_EVENT_PATH");
        if (path == null) {
            return null;
        }
        try {
            String event = String.join((CharSequence)" ", Files.readAllLines(Paths.get(path, new String[0])));
            return GithubEventParser.parsePullRequestHeadSha(event);
        }
        catch (IOException e) {
            return null;
        }
    }

    static @Nullable String parsePullRequestHeadSha(String eventJson) {
        Matcher matcher = GITHUB_EVENT_PATTERN.matcher(eventJson.trim());
        if (!matcher.matches()) {
            return null;
        }
        return matcher.group(1);
    }
}

