/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.cienvironment;

import io.cucumber.cienvironment.CiEnvironment;
import java.util.Objects;
import java.util.Optional;
import org.jspecify.annotations.Nullable;

final class CiEnvironmentImpl
implements CiEnvironment {
    private final String name;
    private final String url;
    private final @Nullable String buildNumber;
    private final @Nullable Git git;

    CiEnvironmentImpl(String name, String url, @Nullable String buildNumber, @Nullable Git git) {
        this.name = Objects.requireNonNull(name);
        this.url = Objects.requireNonNull(url);
        this.buildNumber = buildNumber;
        this.git = git;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getUrl() {
        return this.url;
    }

    @Override
    public Optional<String> getBuildNumber() {
        return Optional.ofNullable(this.buildNumber);
    }

    @Override
    public Optional<CiEnvironment.Git> getGit() {
        return Optional.ofNullable(this.git);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CiEnvironmentImpl that = (CiEnvironmentImpl)o;
        return Objects.equals(this.name, that.name) && Objects.equals(this.url, that.url) && Objects.equals(this.buildNumber, that.buildNumber) && Objects.equals(this.git, that.git);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.url, this.buildNumber, this.git);
    }

    public String toString() {
        return "CiEnvironmentImpl{name='" + this.name + "', url='" + this.url + "', buildNumber='" + this.buildNumber + "', git=" + String.valueOf(this.git) + "}";
    }

    static final class Git
    implements CiEnvironment.Git {
        private final String remote;
        private final String revision;
        private final @Nullable String branch;
        private final @Nullable String tag;

        Git(String remote, String revision, @Nullable String branch, @Nullable String tag) {
            this.remote = Objects.requireNonNull(remote);
            this.revision = Objects.requireNonNull(revision);
            this.branch = branch;
            this.tag = tag;
        }

        @Override
        public String getRemote() {
            return this.remote;
        }

        @Override
        public String getRevision() {
            return this.revision;
        }

        @Override
        public Optional<String> getBranch() {
            return Optional.ofNullable(this.branch);
        }

        @Override
        public Optional<String> getTag() {
            return Optional.ofNullable(this.tag);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Git git = (Git)o;
            return Objects.equals(this.remote, git.remote) && Objects.equals(this.revision, git.revision) && Objects.equals(this.branch, git.branch) && Objects.equals(this.tag, git.tag);
        }

        public int hashCode() {
            return Objects.hash(this.remote, this.revision, this.branch, this.tag);
        }

        public String toString() {
            return "Git{remote='" + this.remote + "', revision='" + this.revision + "', branch='" + this.branch + "', tag='" + this.tag + "'}";
        }
    }
}

