/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.cienvironment;

import io.cucumber.cienvironment.CiEnvironment;
import io.cucumber.cienvironment.CiEnvironmentImpl;
import io.cucumber.cienvironment.CiEnvironments;
import io.cucumber.cienvironment.RemoveUserInfo;
import io.cucumber.cienvironment.VariableExpression;
import io.cucumber.cienvironment.internal.com.eclipsesource.json.Json;
import io.cucumber.cienvironment.internal.com.eclipsesource.json.JsonValue;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.Optional;

public final class DetectCiEnvironment {
    private DetectCiEnvironment() {
    }

    public static Optional<CiEnvironment> detectCiEnvironment(Map<String, String> env) {
        return CiEnvironments.TEMPLATES.stream().map(ciEnvironment -> DetectCiEnvironment.detect(ciEnvironment, env)).filter(Optional::isPresent).map(Optional::get).findFirst();
    }

    private static Optional<CiEnvironment> detect(CiEnvironment ci, Map<String, String> env) {
        String url = VariableExpression.evaluate(ci.getUrl(), env);
        if (url == null) {
            return Optional.empty();
        }
        return Optional.of(new CiEnvironmentImpl(ci.getName(), url, ci.getBuildNumber().map(buildNumber -> VariableExpression.evaluate(buildNumber, env)).orElse(null), DetectCiEnvironment.detectGit(ci, env)));
    }

    private static CiEnvironmentImpl.Git detectGit(CiEnvironment ci, Map<String, String> env) {
        String revision = DetectCiEnvironment.evaluateRevision(ci, env);
        if (revision == null) {
            return null;
        }
        if (!ci.getGit().isPresent()) {
            return null;
        }
        CiEnvironment.Git git = ci.getGit().get();
        String remote = VariableExpression.evaluate(git.getRemote(), env);
        if (remote == null) {
            return null;
        }
        return new CiEnvironmentImpl.Git(RemoveUserInfo.fromUrl(remote), revision, git.getBranch().map(branch -> VariableExpression.evaluate(branch, env)).orElse(null), git.getTag().map(tag -> VariableExpression.evaluate(tag, env)).orElse(null));
    }

    private static String evaluateRevision(CiEnvironment ci, Map<String, String> env) {
        String revision = DetectCiEnvironment.evaluateRevisionGithub(env);
        if (revision != null) {
            return revision;
        }
        return ci.getGit().map(git -> VariableExpression.evaluate(git.getRevision(), env)).orElse(null);
    }

    private static String evaluateRevisionGithub(Map<String, String> env) {
        String string;
        block10: {
            if (!"pull_request".equals(env.get("GITHUB_EVENT_NAME"))) {
                return null;
            }
            if (env.get("GITHUB_EVENT_PATH") == null) {
                throw new RuntimeException("GITHUB_EVENT_PATH not set");
            }
            InputStreamReader is = DetectCiEnvironment.getGithubEvent(env);
            try {
                JsonValue event = Json.parse(is);
                string = event.asObject().get("pull_request").asObject().get("head").asObject().get("sha").asString();
                if (is == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    throw new RuntimeException("Could not read .pull_request.head.sha from " + env.get("GITHUB_EVENT_PATH"), e);
                }
            }
            is.close();
        }
        return string;
    }

    private static InputStreamReader getGithubEvent(Map<String, String> env) throws FileNotFoundException {
        return new InputStreamReader((InputStream)new FileInputStream(env.get("GITHUB_EVENT_PATH")), StandardCharsets.UTF_8);
    }
}

