/*
 * Decompiled with CFR 0.152.
 */
package io.crate.shade.org.postgresql.xa;

import io.crate.shade.org.postgresql.Driver;
import io.crate.shade.org.postgresql.core.BaseConnection;
import io.crate.shade.org.postgresql.ds.common.BaseDataSource;
import io.crate.shade.org.postgresql.xa.PGXAConnection;
import io.crate.shade.org.postgresql.xa.PGXADataSourceFactory;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.logging.Logger;
import javax.naming.Reference;
import javax.naming.Referenceable;
import javax.sql.XAConnection;
import javax.sql.XADataSource;

public class PGXADataSource
extends BaseDataSource
implements XADataSource,
Referenceable {
    @Override
    public XAConnection getXAConnection() throws SQLException {
        return this.getXAConnection(this.getUser(), this.getPassword());
    }

    @Override
    public XAConnection getXAConnection(String user, String password) throws SQLException {
        Connection con = super.getConnection(user, password);
        return new PGXAConnection((BaseConnection)con);
    }

    @Override
    public String getDescription() {
        return "JDBC3 XA-enabled DataSource from " + Driver.getVersion();
    }

    @Override
    protected Reference createReference() {
        return new Reference(this.getClass().getName(), PGXADataSourceFactory.class.getName(), null);
    }

    @Override
    public Logger getParentLogger() throws SQLFeatureNotSupportedException {
        throw Driver.notImplemented(this.getClass(), "getParentLogger()");
    }
}

