/*
 * Decompiled with CFR 0.152.
 */
package io.crate.shade.org.postgresql.core;

import io.crate.shade.org.postgresql.PGProperty;
import io.crate.shade.org.postgresql.core.Logger;
import io.crate.shade.org.postgresql.core.PGStream;
import io.crate.shade.org.postgresql.core.QueryExecutor;
import io.crate.shade.org.postgresql.core.v3.ConnectionFactoryImpl;
import io.crate.shade.org.postgresql.util.GT;
import io.crate.shade.org.postgresql.util.HostSpec;
import io.crate.shade.org.postgresql.util.PSQLException;
import io.crate.shade.org.postgresql.util.PSQLState;
import java.io.IOException;
import java.sql.SQLException;
import java.util.Properties;

public abstract class ConnectionFactory {
    public static QueryExecutor openConnection(HostSpec[] hostSpecs, String user, String database, Properties info, Logger logger) throws SQLException {
        ConnectionFactoryImpl connectionFactory;
        QueryExecutor queryExecutor;
        String protoName = PGProperty.PROTOCOL_VERSION.get(info);
        if ((protoName == null || "".equals(protoName) || "2".equals(protoName) || "3".equals(protoName)) && (queryExecutor = ((ConnectionFactory)(connectionFactory = new ConnectionFactoryImpl())).openConnectionImpl(hostSpecs, user, database, info, logger)) != null) {
            return queryExecutor;
        }
        throw new PSQLException(GT.tr("A connection could not be made using the requested protocol {0}.", protoName), PSQLState.CONNECTION_UNABLE_TO_CONNECT);
    }

    public abstract QueryExecutor openConnectionImpl(HostSpec[] var1, String var2, String var3, Properties var4, Logger var5) throws SQLException;

    protected void closeStream(PGStream newStream) {
        if (newStream != null) {
            try {
                newStream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

