/*
 * Decompiled with CFR 0.152.
 */
package io.contek.invoker.security;

import com.google.common.base.Charsets;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import javax.annotation.concurrent.Immutable;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;

@Immutable
public enum SecretKeyAlgorithm {
    HMAC_MD5("HmacMD5"),
    HMAC_SHA256("HmacSHA256"),
    HMAC_SHA384("HmacSHA384"),
    HMAC_SHA512("HmacSHA512");

    private final String value;

    private SecretKeyAlgorithm(String value) {
        this.value = value;
    }

    public Mac setupMac(String secret) {
        return this.setupMac(secret.getBytes(Charsets.UTF_8));
    }

    public Mac setupMac(byte[] secret) {
        try {
            Mac mac = Mac.getInstance(this.value);
            SecretKeySpec spec = new SecretKeySpec(secret, this.value);
            mac.init(spec);
            return mac;
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalStateException(e);
        }
        catch (InvalidKeyException e) {
            throw new IllegalArgumentException(e);
        }
    }
}

