/*
 * Decompiled with CFR 0.152.
 */
package io.contek.invoker.commons.api.websocket;

import io.contek.invoker.commons.api.websocket.AnyWebSocketMessage;
import io.contek.invoker.commons.api.websocket.ConsumerState;
import io.contek.invoker.commons.api.websocket.ISubscribingConsumer;
import io.contek.invoker.commons.api.websocket.IWebSocketComponent;
import io.contek.invoker.commons.api.websocket.SubscriptionState;
import io.contek.invoker.commons.api.websocket.WebSocketSession;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.Nullable;
import javax.annotation.concurrent.ThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public abstract class BaseWebSocketChannel<Message>
implements IWebSocketComponent {
    private static final Logger log = LoggerFactory.getLogger(BaseWebSocketChannel.class);
    private final AtomicReference<SubscriptionState> stateHolder = new AtomicReference<SubscriptionState>(SubscriptionState.UNSUBSCRIBED);
    private final List<ISubscribingConsumer<Message>> consumers = new LinkedList<ISubscribingConsumer<Message>>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void addConsumer(ISubscribingConsumer<Message> consumer) {
        List<ISubscribingConsumer<Message>> list = this.consumers;
        synchronized (list) {
            AtomicReference<SubscriptionState> atomicReference = this.stateHolder;
            synchronized (atomicReference) {
                SubscriptionState state = this.stateHolder.get();
                consumer.onStateChange(state);
            }
            this.consumers.add(consumer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void heartbeat(WebSocketSession session) {
        List<ISubscribingConsumer<Message>> list = this.consumers;
        synchronized (list) {
            ConsumerState childConsumerState = this.getChildConsumerState();
            AtomicReference<SubscriptionState> atomicReference = this.stateHolder;
            synchronized (atomicReference) {
                SubscriptionState currentState = this.stateHolder.get();
                SubscriptionState newState = null;
                if (currentState == SubscriptionState.SUBSCRIBED && childConsumerState == ConsumerState.IDLE) {
                    log.info("Unsubscribing channel {}.", (Object)this.getDisplayName());
                    newState = this.unsubscribe(session);
                    if (newState == SubscriptionState.SUBSCRIBED || newState == SubscriptionState.SUBSCRIBING) {
                        log.error("Channel {} has invalid state after unsubscribe: {}.", (Object)this.getDisplayName(), (Object)newState);
                    }
                } else if (currentState == SubscriptionState.UNSUBSCRIBED && childConsumerState == ConsumerState.ACTIVE) {
                    log.info("Subscribing channel {}.", (Object)this.getDisplayName());
                    newState = this.subscribe(session);
                    if (newState == SubscriptionState.UNSUBSCRIBED || newState == SubscriptionState.UNSUBSCRIBING) {
                        log.error("Channel {} has invalid state after subscribe: {}.", (Object)this.getDisplayName(), (Object)newState);
                    }
                }
                if (newState != null) {
                    this.setState(newState);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final ConsumerState getState() {
        Object object = this.consumers;
        synchronized (object) {
            if (this.getChildConsumerState() == ConsumerState.ACTIVE) {
                return ConsumerState.ACTIVE;
            }
        }
        object = this.stateHolder;
        synchronized (object) {
            return this.stateHolder.get() != SubscriptionState.UNSUBSCRIBED ? ConsumerState.ACTIVE : ConsumerState.IDLE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void onMessage(AnyWebSocketMessage message) {
        List<ISubscribingConsumer<Message>> list = this.consumers;
        synchronized (list) {
            Object casted = this.tryCast(message);
            if (casted != null) {
                this.consumers.forEach(consumer -> consumer.onNext(casted));
            }
        }
        SubscriptionState newState = this.getState(message);
        if (newState != null) {
            log.info("Channel {} is now {}.", (Object)this.getDisplayName(), (Object)newState);
            this.setState(newState);
        }
    }

    @Override
    public final void afterDisconnect() {
        this.reset();
        this.setState(SubscriptionState.UNSUBSCRIBED);
    }

    protected abstract String getDisplayName();

    protected abstract SubscriptionState subscribe(WebSocketSession var1);

    protected abstract SubscriptionState unsubscribe(WebSocketSession var1);

    @Nullable
    protected abstract SubscriptionState getState(AnyWebSocketMessage var1);

    protected abstract Class<Message> getMessageType();

    protected abstract boolean accepts(Message var1);

    protected abstract void reset();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ConsumerState getChildConsumerState() {
        List<ISubscribingConsumer<Message>> list = this.consumers;
        synchronized (list) {
            this.consumers.removeIf(consumer -> consumer.getState() == ConsumerState.TERMINATED);
            return this.consumers.stream().anyMatch(consumer -> consumer.getState() == ConsumerState.ACTIVE) ? ConsumerState.ACTIVE : ConsumerState.IDLE;
        }
    }

    @Nullable
    private Message tryCast(AnyWebSocketMessage message) {
        if (!this.getMessageType().isAssignableFrom(message.getClass())) {
            return null;
        }
        Message casted = this.getMessageType().cast(message);
        return (Message)(this.accepts(casted) ? casted : null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setState(SubscriptionState state) {
        List<ISubscribingConsumer<Message>> list = this.consumers;
        synchronized (list) {
            AtomicReference<SubscriptionState> atomicReference = this.stateHolder;
            synchronized (atomicReference) {
                this.consumers.forEach(consumer -> consumer.onStateChange(state));
                this.stateHolder.set(state);
            }
        }
    }
}

