/*
 * Decompiled with CFR 0.152.
 */
package io.contek.invoker.commons.api.websocket;

import com.google.common.collect.ImmutableList;
import io.contek.invoker.commons.api.actor.IActor;
import io.contek.invoker.commons.api.actor.ratelimit.IRateLimitThrottle;
import io.contek.invoker.commons.api.actor.ratelimit.RateLimitQuota;
import io.contek.invoker.commons.api.websocket.AnyWebSocketMessage;
import io.contek.invoker.commons.api.websocket.IWebSocketApi;
import io.contek.invoker.commons.api.websocket.IWebSocketAuthenticator;
import io.contek.invoker.commons.api.websocket.IWebSocketComponent;
import io.contek.invoker.commons.api.websocket.IWebSocketMessageParser;
import io.contek.invoker.commons.api.websocket.WebSocketCall;
import io.contek.invoker.commons.api.websocket.WebSocketComponentManager;
import io.contek.invoker.commons.api.websocket.WebSocketRuntimeException;
import io.contek.invoker.commons.api.websocket.WebSocketSession;
import io.contek.invoker.security.ICredential;
import java.io.EOFException;
import java.io.IOException;
import java.net.SocketTimeoutException;
import java.util.List;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.concurrent.ThreadSafe;
import okhttp3.Response;
import okhttp3.WebSocket;
import okhttp3.WebSocketListener;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public abstract class BaseWebSocketApi
implements IWebSocketApi {
    private static final Logger log = LoggerFactory.getLogger(BaseWebSocketApi.class);
    private final IActor actor;
    private final IWebSocketMessageParser parser;
    private final IWebSocketAuthenticator authenticator;
    private final Handler handler = new Handler();
    private final ScheduledExecutorService scheduler = Executors.newSingleThreadScheduledExecutor();
    private final AtomicReference<WebSocketSession> sessionHolder = new AtomicReference();
    private final AtomicReference<ScheduledFuture<?>> scheduleHolder = new AtomicReference();
    private final WebSocketComponentManager components = new WebSocketComponentManager();

    protected BaseWebSocketApi(IActor actor, IWebSocketMessageParser parser, IWebSocketAuthenticator authenticator) {
        this.actor = actor;
        this.parser = parser;
        this.authenticator = authenticator;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void attach(IWebSocketComponent channel) {
        WebSocketComponentManager webSocketComponentManager = this.components;
        synchronized (webSocketComponentManager) {
            this.components.attach(channel);
            this.activate();
        }
    }

    protected abstract ImmutableList<RateLimitQuota> getRequiredQuotas();

    protected abstract WebSocketCall createCall(ICredential var1);

    protected abstract void checkErrorMessage(AnyWebSocketMessage var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void forwardMessage(String text) {
        AnyWebSocketMessage message = this.parser.parse(text);
        this.checkErrorMessage(message);
        this.authenticator.onMessage(message);
        WebSocketComponentManager webSocketComponentManager = this.components;
        synchronized (webSocketComponentManager) {
            this.components.onMessage(message);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void connect() {
        AtomicReference<WebSocketSession> atomicReference = this.sessionHolder;
        synchronized (atomicReference) {
            this.sessionHolder.updateAndGet(oldValue -> {
                if (oldValue != null) {
                    return oldValue;
                }
                WebSocketCall call = this.createCall(this.actor.getCredential());
                IRateLimitThrottle throttle = this.actor.getRateLimitThrottle();
                throttle.acquire(this.getClass().getSimpleName(), (List<RateLimitQuota>)this.getRequiredQuotas());
                WebSocketSession session = call.submit(this.actor.getHttpClient(), this.handler);
                this.activate();
                return session;
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void afterDisconnect() {
        AtomicReference<WebSocketSession> atomicReference = this.sessionHolder;
        synchronized (atomicReference) {
            this.sessionHolder.set(null);
            WebSocketComponentManager webSocketComponentManager = this.components;
            synchronized (webSocketComponentManager) {
                this.components.afterDisconnect();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void heartbeat() {
        try {
            AtomicReference<WebSocketSession> atomicReference = this.sessionHolder;
            synchronized (atomicReference) {
                WebSocketComponentManager webSocketComponentManager = this.components;
                synchronized (webSocketComponentManager) {
                    this.components.refresh();
                    WebSocketSession session = this.sessionHolder.get();
                    if (session == null) {
                        if (!this.components.hasComponent()) {
                            this.deactivate();
                            return;
                        }
                        if (this.components.hasActiveComponent()) {
                            this.connect();
                        }
                        return;
                    }
                    if (!this.components.hasActiveComponent()) {
                        log.info("No active components. Closing session.");
                        session.close();
                        return;
                    }
                    if (!this.authenticator.isCompleted()) {
                        this.authenticator.handshake(session);
                        return;
                    }
                    this.components.heartbeat(session);
                }
            }
        }
        catch (Throwable t) {
            log.error("Heartbeat failed.", t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void activate() {
        AtomicReference<ScheduledFuture<?>> atomicReference = this.scheduleHolder;
        synchronized (atomicReference) {
            this.scheduleHolder.updateAndGet(oldValue -> {
                if (oldValue != null && !oldValue.isDone()) {
                    return oldValue;
                }
                return this.scheduler.scheduleWithFixedDelay(this::heartbeat, 0L, 1L, TimeUnit.SECONDS);
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deactivate() {
        AtomicReference<ScheduledFuture<?>> atomicReference = this.scheduleHolder;
        synchronized (atomicReference) {
            this.scheduleHolder.updateAndGet(oldValue -> {
                if (oldValue == null) {
                    return null;
                }
                if (!oldValue.isDone()) {
                    oldValue.cancel(true);
                }
                return null;
            });
        }
    }

    @ThreadSafe
    private final class Handler
    extends WebSocketListener {
        private Handler() {
        }

        public void onClosed(WebSocket ws, int code, String reason) {
            log.info("Session is closed: {} {}.", (Object)code, (Object)reason);
            try {
                BaseWebSocketApi.this.afterDisconnect();
            }
            catch (Throwable t) {
                log.error("Failed to handle closed session.", t);
            }
        }

        public void onFailure(WebSocket ws, Throwable t, @Nullable Response response) {
            if (t instanceof SocketTimeoutException) {
                log.warn("Shutting down inactive session.", t);
            } else if (t instanceof EOFException) {
                log.warn("Server closed connection.", t);
            } else if (t instanceof IOException) {
                log.warn("Connection interrupted.", t);
            } else if (t instanceof WebSocketRuntimeException) {
                log.warn("Encountered runtime exception.", t);
            } else {
                log.error("Encountered unknown error: {}.", (Object)response, (Object)t);
            }
            try {
                ws.cancel();
                BaseWebSocketApi.this.afterDisconnect();
            }
            catch (Throwable t2) {
                log.error("Failed to handle failure.", t2);
            }
        }

        public void onMessage(WebSocket ws, String text) {
            BaseWebSocketApi.this.forwardMessage(text);
        }

        public void onOpen(WebSocket ws, Response response) {
            log.info("Session is open: {}.", (Object)response);
        }
    }
}

