/*
 * Decompiled with CFR 0.152.
 */
package io.contek.invoker.commons.api.rest;

import com.google.gson.Gson;
import com.google.gson.JsonSyntaxException;
import io.contek.invoker.commons.api.rest.RestParsingException;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

@Immutable
public final class RestResponse {
    private static final Gson gson = new Gson();
    private final int code;
    private final String stringValue;

    RestResponse(int code, @Nullable String stringValue) {
        this.code = code;
        this.stringValue = stringValue;
    }

    public int getCode() {
        return this.code;
    }

    @Nullable
    public String getStringValue() {
        return this.stringValue;
    }

    @Nullable
    public <T> T getAs(Class<T> type) throws RestParsingException {
        try {
            return (T)(this.stringValue == null ? null : gson.fromJson(this.stringValue, type));
        }
        catch (JsonSyntaxException e) {
            throw new RestParsingException(this, type);
        }
    }
}

