/*
 * Decompiled with CFR 0.152.
 */
package io.contek.invoker.commons.api.rest;

import com.google.gson.Gson;
import io.contek.invoker.commons.api.rest.RestMediaBody;
import io.contek.invoker.commons.api.rest.RestParams;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.concurrent.Immutable;
import okhttp3.MediaType;

@Immutable
public enum RestMediaType {
    JSON(Objects.requireNonNull(MediaType.parse((String)"application/json; charset=utf-8")), RestMediaType::toJsonString),
    FORM(Objects.requireNonNull(MediaType.parse((String)"application/x-www-form-urlencoded")), RestMediaType::toFormString);

    private static final Gson gson;
    private final MediaType value;
    private final Function<RestParams, String> composer;

    private RestMediaType(MediaType value, Function<RestParams, String> composer) {
        this.value = value;
        this.composer = composer;
    }

    public String getValue() {
        return this.value.toString();
    }

    public RestMediaBody createBody(RestParams params) {
        return new RestMediaBody(this.value, this.composer.apply(params));
    }

    private static String toJsonString(RestParams params) {
        return gson.toJson(params.getValues());
    }

    private static String toFormString(RestParams params) {
        return params.getQueryString();
    }

    static {
        gson = new Gson();
    }
}

