/*
 * Decompiled with CFR 0.152.
 */
package io.contek.invoker.commons.api.rest;

import io.contek.invoker.commons.api.actor.http.BaseHttpContext;
import java.time.Duration;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;

@Immutable
public final class RestContext
extends BaseHttpContext {
    private final Duration connectionTimeout;
    private final Duration readTimeout;
    private final Duration writeTimeout;

    private RestContext(String baseUrl, @Nullable Duration connectionTimeout, @Nullable Duration readTimeout, @Nullable Duration writeTimeout) {
        super(baseUrl);
        this.connectionTimeout = connectionTimeout;
        this.readTimeout = readTimeout;
        this.writeTimeout = writeTimeout;
    }

    public static RestContext forBaseUrl(String baseUrl) {
        return RestContext.newBuilder().setBaseUrl(baseUrl).build();
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    @Override
    @Nullable
    public Duration getConnectionTimeout() {
        return this.connectionTimeout;
    }

    @Override
    @Nullable
    public Duration getReadTimeout() {
        return this.readTimeout;
    }

    @Override
    @Nullable
    public Duration getWriteTimeout() {
        return this.writeTimeout;
    }

    @NotThreadSafe
    public static final class Builder {
        private String baseUrl;
        private Duration connectionTimeout;
        private Duration readTimeout;
        private Duration writeTimeout;

        public Builder setBaseUrl(String baseUrl) {
            this.baseUrl = baseUrl;
            return this;
        }

        public Builder setConnectionTimeout(@Nullable Duration connectionTimeout) {
            this.connectionTimeout = connectionTimeout;
            return this;
        }

        public Builder setReadTimeout(@Nullable Duration readTimeout) {
            this.readTimeout = readTimeout;
            return this;
        }

        public Builder setWriteTimeout(@Nullable Duration writeTimeout) {
            this.writeTimeout = writeTimeout;
            return this;
        }

        public RestContext build() {
            if (this.baseUrl == null) {
                throw new IllegalArgumentException("No base URL specified");
            }
            return new RestContext(this.baseUrl, this.connectionTimeout, this.readTimeout, this.writeTimeout);
        }

        private Builder() {
        }
    }
}

