/*
 * Decompiled with CFR 0.152.
 */
package io.contek.invoker.commons.api.rest;

import com.google.common.collect.ImmutableList;
import io.contek.invoker.commons.api.actor.IActor;
import io.contek.invoker.commons.api.actor.http.AnyHttpException;
import io.contek.invoker.commons.api.actor.ratelimit.IRateLimitThrottle;
import io.contek.invoker.commons.api.actor.ratelimit.RateLimitQuota;
import io.contek.invoker.commons.api.rest.RestCall;
import io.contek.invoker.commons.api.rest.RestResponse;
import io.contek.invoker.security.ICredential;
import java.util.List;
import java.util.Objects;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public abstract class BaseRestRequest<R> {
    private final IActor actor;

    protected BaseRestRequest(IActor actor) {
        this.actor = actor;
    }

    public final R submit() throws AnyHttpException {
        RestCall call = this.createCall(this.actor.getCredential());
        IRateLimitThrottle throttle = this.actor.getRateLimitThrottle();
        throttle.acquire(this.getClass().getSimpleName(), (List<RateLimitQuota>)this.getRequiredQuotas());
        RestResponse response = call.submit(this.actor.getHttpClient());
        return Objects.requireNonNull(response.getAs(this.getResponseType()));
    }

    protected abstract ImmutableList<RateLimitQuota> getRequiredQuotas();

    protected abstract RestCall createCall(ICredential var1);

    protected abstract Class<R> getResponseType();
}

