/*
 * Decompiled with CFR 0.152.
 */
package io.contek.invoker.commons.api.actor.ratelimit;

import com.google.common.base.Joiner;
import io.contek.invoker.commons.api.actor.ratelimit.RateLimitQuota;
import io.contek.invoker.commons.api.actor.ratelimit.RateLimitType;
import io.github.resilience4j.ratelimiter.RateLimiter;
import io.github.resilience4j.ratelimiter.RateLimiterConfig;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;

@Immutable
public final class RateLimitRule {
    private final String name;
    private final RateLimitType type;
    private final int maxPermits;
    private final Duration resetPeriod;

    private RateLimitRule(String name, RateLimitType type, int maxPermits, Duration resetPeriod) {
        this.name = name;
        this.type = type;
        this.maxPermits = maxPermits;
        this.resetPeriod = resetPeriod;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public RateLimitQuota createRateLimitQuota(int permits) {
        return new RateLimitQuota(this.name, this.type, permits);
    }

    public String getName() {
        return this.name;
    }

    public RateLimitType getType() {
        return this.type;
    }

    public int getMaxPermits() {
        return this.maxPermits;
    }

    public Duration getResetPeriod() {
        return this.resetPeriod;
    }

    RateLimiter createRateLimiter(String key) {
        return RateLimiter.of((String)Joiner.on((char)'_').join((Object)this.type, (Object)this.name, new Object[]{key}), (RateLimiterConfig)RateLimiterConfig.custom().limitForPeriod(2400).limitRefreshPeriod(Duration.of(1L, ChronoUnit.MINUTES)).build());
    }

    @NotThreadSafe
    public static final class Builder {
        private String name;
        private RateLimitType type;
        private int maxPermits;
        private Duration resetPeriod;

        public Builder setName(String name) {
            this.name = name;
            return this;
        }

        public Builder setType(RateLimitType type) {
            this.type = type;
            return this;
        }

        public Builder setMaxPermits(int maxPermits) {
            this.maxPermits = maxPermits;
            return this;
        }

        public Builder setResetPeriod(Duration resetPeriod) {
            this.resetPeriod = resetPeriod;
            return this;
        }

        public RateLimitRule build() {
            if (this.name == null) {
                throw new IllegalArgumentException("No rule name specified");
            }
            if (this.type == null) {
                throw new IllegalArgumentException("No rule type specified");
            }
            if (this.maxPermits <= 0) {
                throw new IllegalArgumentException("Invalid max permits");
            }
            if (this.resetPeriod == null) {
                throw new IllegalArgumentException("No reset period specified");
            }
            return new RateLimitRule(this.name, this.type, this.maxPermits, this.resetPeriod);
        }

        private Builder() {
        }
    }
}

