/*
 * Decompiled with CFR 0.152.
 */
package io.contek.invoker.commons.api.actor.http;

import io.contek.invoker.commons.api.actor.http.AnyHttpException;
import io.contek.invoker.commons.api.actor.http.HttpConnectionException;
import io.contek.invoker.commons.api.actor.http.IHttpClient;
import java.io.IOException;
import java.net.InetAddress;
import javax.annotation.concurrent.ThreadSafe;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.WebSocket;
import okhttp3.WebSocketListener;

@ThreadSafe
public final class SimpleHttpClient
implements IHttpClient {
    private final OkHttpClient delegate;
    private final InetAddress boundLocalAddress;

    public SimpleHttpClient(OkHttpClient delegate, InetAddress boundLocalAddress) {
        this.delegate = delegate;
        this.boundLocalAddress = boundLocalAddress;
    }

    @Override
    public Response submit(Request request) throws HttpConnectionException {
        try {
            return this.delegate.newCall(request).execute();
        }
        catch (IOException e) {
            throw new HttpConnectionException(e);
        }
    }

    @Override
    public WebSocket submit(Request request, WebSocketListener listener) throws AnyHttpException {
        return this.delegate.newWebSocket(request, listener);
    }

    @Override
    public InetAddress getBoundLocalAddress() {
        return this.boundLocalAddress;
    }
}

