/*
 * Decompiled with CFR 0.152.
 */
package io.contek.invoker.bybit.api.websocket.market;

import io.contek.invoker.bybit.api.websocket.WebSocketChannel;
import io.contek.invoker.bybit.api.websocket.common.WebSocketTopicMessage;
import java.util.List;
import javax.annotation.concurrent.NotThreadSafe;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public abstract class OrderBookChannel
extends WebSocketChannel<Message> {
    private final String topic;

    OrderBookChannel(String topic) {
        this.topic = topic;
    }

    @Override
    protected String getTopic() {
        return this.topic;
    }

    protected Class<Message> getMessageType() {
        return Message.class;
    }

    protected boolean accepts(Message message) {
        return this.topic.equals(message.topic);
    }

    @NotThreadSafe
    public static abstract class Message
    extends WebSocketTopicMessage {
        public String type;
        public Long cross_seq;
        public Long timestamp_e6;
    }

    @NotThreadSafe
    public static final class OrderBookLevel {
        public Double price;
        public String symbol;
        public Long id;
        public String side;
        public Double size;
    }

    @NotThreadSafe
    public static final class SnapshotMessage
    extends Message {
        public List<OrderBookLevel> data;
    }

    @NotThreadSafe
    public static final class DeltaData {
        public List<OrderBookLevel> delete;
        public List<OrderBookLevel> update;
        public List<OrderBookLevel> insert;
        public Long transactTimeE6;
    }

    @NotThreadSafe
    public static final class DeltaMessage
    extends Message {
        public DeltaData data;
    }
}

