/*
 * Decompiled with CFR 0.152.
 */
package io.contek.invoker.bybit.api.websocket.market;

import io.contek.invoker.bybit.api.websocket.WebSocketApi;
import io.contek.invoker.bybit.api.websocket.market.OrderBook200Channel;
import io.contek.invoker.bybit.api.websocket.market.OrderBook25Channel;
import io.contek.invoker.bybit.api.websocket.market.TradeChannel;
import io.contek.invoker.commons.api.actor.IActor;
import io.contek.invoker.commons.api.websocket.IWebSocketComponent;
import io.contek.invoker.commons.api.websocket.WebSocketContext;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public final class MarketWebSocketApi
extends WebSocketApi {
    private final Map<String, OrderBook25Channel> orderBook25Channels = new HashMap<String, OrderBook25Channel>();
    private final Map<String, OrderBook200Channel> orderBook200Channels = new HashMap<String, OrderBook200Channel>();
    private final Map<String, TradeChannel> tradeChannels = new HashMap<String, TradeChannel>();

    public MarketWebSocketApi(IActor actor, WebSocketContext context) {
        super(actor, context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OrderBook25Channel getOrderBook25Channel(String symbol) {
        Map<String, OrderBook25Channel> map = this.orderBook25Channels;
        synchronized (map) {
            return this.orderBook25Channels.computeIfAbsent(symbol, k -> {
                OrderBook25Channel result = new OrderBook25Channel((String)k);
                this.attach((IWebSocketComponent)result);
                return result;
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OrderBook200Channel getOrderBook200Channel(String symbol) {
        Map<String, OrderBook200Channel> map = this.orderBook200Channels;
        synchronized (map) {
            return this.orderBook200Channels.computeIfAbsent(symbol, k -> {
                OrderBook200Channel result = new OrderBook200Channel((String)k);
                this.attach((IWebSocketComponent)result);
                return result;
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TradeChannel getTradeChannel(String symbol) {
        Map<String, TradeChannel> map = this.tradeChannels;
        synchronized (map) {
            return this.tradeChannels.computeIfAbsent(symbol, k -> {
                TradeChannel result = new TradeChannel((String)k);
                this.attach((IWebSocketComponent)result);
                return result;
            });
        }
    }
}

