/*
 * Decompiled with CFR 0.152.
 */
package io.contek.invoker.bybit.api.rest.user;

import com.google.common.collect.ImmutableList;
import io.contek.invoker.bybit.api.ApiFactory;
import io.contek.invoker.bybit.api.rest.common.RestResponse;
import io.contek.invoker.bybit.api.rest.user.UserRestRequest;
import io.contek.invoker.commons.api.actor.IActor;
import io.contek.invoker.commons.api.actor.ratelimit.RateLimitQuota;
import io.contek.invoker.commons.api.rest.RestContext;
import io.contek.invoker.commons.api.rest.RestMethod;
import io.contek.invoker.commons.api.rest.RestParams;
import java.util.Objects;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public final class PostUserLeverageSave
extends UserRestRequest<Response> {
    private String symbol;
    private Double leverage;

    PostUserLeverageSave(IActor actor, RestContext context) {
        super(actor, context);
    }

    public PostUserLeverageSave setSymbol(String symbol) {
        this.symbol = symbol;
        return this;
    }

    public PostUserLeverageSave setLeverage(Double leverage) {
        this.leverage = leverage;
        return this;
    }

    @Override
    protected RestMethod getMethod() {
        return RestMethod.POST;
    }

    @Override
    protected String getEndpointPath() {
        return "/user/leverage/save";
    }

    @Override
    protected RestParams getParams() {
        RestParams.Builder builder = RestParams.newBuilder();
        Objects.requireNonNull(this.symbol);
        builder.add("symbol", this.symbol);
        Objects.requireNonNull(this.leverage);
        builder.add("leverage", this.leverage.doubleValue());
        return builder.build();
    }

    protected ImmutableList<RateLimitQuota> getRequiredQuotas() {
        return ApiFactory.RateLimits.ONE_REST_PRIVATE_POSITION_WRITE_REQUEST;
    }

    protected Class<Response> getResponseType() {
        return Response.class;
    }

    @NotThreadSafe
    public static final class Response
    extends RestResponse<Double> {
    }
}

