/*
 * Decompiled with CFR 0.152.
 */
package io.contek.invoker.bybit.api.rest.user;

import com.google.common.collect.ImmutableList;
import io.contek.invoker.bybit.api.ApiFactory;
import io.contek.invoker.bybit.api.common._UserTradingRecords;
import io.contek.invoker.bybit.api.rest.common.RestResponse;
import io.contek.invoker.bybit.api.rest.user.UserRestRequest;
import io.contek.invoker.commons.api.actor.IActor;
import io.contek.invoker.commons.api.actor.ratelimit.RateLimitQuota;
import io.contek.invoker.commons.api.rest.RestContext;
import io.contek.invoker.commons.api.rest.RestMethod;
import io.contek.invoker.commons.api.rest.RestParams;
import java.util.Objects;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public final class GetExecutionList
extends UserRestRequest<Response> {
    private String symbol;
    private String order_id;
    private Long start_time;
    private Integer page;
    private Integer limit;
    private String order;

    GetExecutionList(IActor actor, RestContext context) {
        super(actor, context);
    }

    public GetExecutionList setSymbol(String symbol) {
        this.symbol = symbol;
        return this;
    }

    @Override
    protected RestMethod getMethod() {
        return RestMethod.GET;
    }

    @Override
    protected String getEndpointPath() {
        return "/v2/private/execution/list";
    }

    @Override
    protected RestParams getParams() {
        RestParams.Builder builder = RestParams.newBuilder();
        Objects.requireNonNull(this.symbol);
        builder.add("symbol", this.symbol);
        if (this.order_id != null) {
            builder.add("order_id", this.order_id);
        }
        if (this.start_time != null) {
            builder.add("start_time", this.start_time.longValue());
        }
        if (this.page != null) {
            builder.add("page", (long)this.page.intValue());
        }
        if (this.limit != null) {
            builder.add("limit", (long)this.limit.intValue());
        }
        if (this.order != null) {
            builder.add("order", this.order);
        }
        return builder.build();
    }

    protected ImmutableList<RateLimitQuota> getRequiredQuotas() {
        return ApiFactory.RateLimits.ONE_REST_PRIVATE_TRADE_READ_REQUEST;
    }

    protected Class<Response> getResponseType() {
        return Response.class;
    }

    @NotThreadSafe
    public static final class Response
    extends RestResponse<_UserTradingRecords> {
    }
}

