/*
 * Decompiled with CFR 0.152.
 */
package io.contek.invoker.bybit.api.rest.market;

import io.contek.invoker.bybit.api.common._Kline;
import io.contek.invoker.bybit.api.rest.common.RestResponse;
import io.contek.invoker.bybit.api.rest.market.MarketRestRequest;
import io.contek.invoker.commons.api.actor.IActor;
import io.contek.invoker.commons.api.rest.RestContext;
import io.contek.invoker.commons.api.rest.RestParams;
import java.util.List;
import java.util.Objects;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public final class GetKlineList
extends MarketRestRequest<Response> {
    public static final int MAX_LIMIT = 200;
    private String symbol;
    private String interval;
    private Long from;
    private Integer limit;

    GetKlineList(IActor actor, RestContext context) {
        super(actor, context);
    }

    public GetKlineList setSymbol(String symbol) {
        this.symbol = symbol;
        return this;
    }

    public GetKlineList setInterval(String interval) {
        this.interval = interval;
        return this;
    }

    public GetKlineList setFrom(Long from) {
        this.from = from;
        return this;
    }

    public GetKlineList setLimit(Integer limit) {
        this.limit = limit;
        return this;
    }

    @Override
    protected String getEndpointPath() {
        return "/v2/public/kline/list";
    }

    @Override
    protected RestParams getParams() {
        RestParams.Builder builder = RestParams.newBuilder();
        Objects.requireNonNull(this.symbol);
        builder.add("symbol", this.symbol);
        Objects.requireNonNull(this.interval);
        builder.add("interval", this.interval);
        Objects.requireNonNull(this.from);
        builder.add("from", this.from.longValue());
        if (this.limit != null) {
            if (this.limit > 200) {
                throw new IllegalArgumentException(Integer.toString(this.limit));
            }
            builder.add("limit", (long)this.limit.intValue());
        }
        return builder.build();
    }

    protected Class<Response> getResponseType() {
        return Response.class;
    }

    @NotThreadSafe
    public static final class Response
    extends RestResponse<List<_Kline>> {
    }
}

