/*
 * Decompiled with CFR 0.152.
 */
package io.contek.invoker.bybit.api.rest.market;

import io.contek.invoker.bybit.api.common._AccountRatio;
import io.contek.invoker.bybit.api.rest.common.RestResponse;
import io.contek.invoker.bybit.api.rest.market.MarketRestRequest;
import io.contek.invoker.commons.api.actor.IActor;
import io.contek.invoker.commons.api.rest.RestContext;
import io.contek.invoker.commons.api.rest.RestParams;
import java.util.List;
import java.util.Objects;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public final class GetAccountRatio
extends MarketRestRequest<Response> {
    public static final int MAX_LIMIT = 500;
    private String symbol;
    private String period;
    private Integer limit;

    GetAccountRatio(IActor actor, RestContext context) {
        super(actor, context);
    }

    public GetAccountRatio setSymbol(String symbol) {
        this.symbol = symbol;
        return this;
    }

    public GetAccountRatio setPeriod(String period) {
        this.period = period;
        return this;
    }

    public GetAccountRatio setLimit(Integer limit) {
        this.limit = limit;
        return this;
    }

    @Override
    protected String getEndpointPath() {
        return "/v2/public/account-ratio";
    }

    @Override
    protected RestParams getParams() {
        RestParams.Builder builder = RestParams.newBuilder();
        Objects.requireNonNull(this.symbol);
        builder.add("symbol", this.symbol);
        Objects.requireNonNull(this.period);
        builder.add("period", this.period);
        if (this.limit != null) {
            if (this.limit > 500) {
                throw new IllegalArgumentException(Integer.toString(this.limit));
            }
            builder.add("limit", (long)this.limit.intValue());
        }
        return builder.build();
    }

    protected Class<Response> getResponseType() {
        return Response.class;
    }

    @NotThreadSafe
    public static final class Response
    extends RestResponse<List<_AccountRatio>> {
    }
}

