/*
 * Decompiled with CFR 0.152.
 */
package io.contek.invoker.bybit.api.rest;

import io.contek.invoker.commons.api.actor.IActor;
import io.contek.invoker.commons.api.rest.BaseRestRequest;
import io.contek.invoker.commons.api.rest.RestCall;
import io.contek.invoker.commons.api.rest.RestContext;
import io.contek.invoker.commons.api.rest.RestMediaBody;
import io.contek.invoker.commons.api.rest.RestMediaType;
import io.contek.invoker.commons.api.rest.RestMethod;
import io.contek.invoker.commons.api.rest.RestParams;
import io.contek.invoker.security.ICredential;
import java.time.Clock;
import java.util.Map;
import java.util.TreeMap;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public abstract class RestRequest<R>
extends BaseRestRequest<R> {
    private static final String API_KEY = "api_key";
    private static final String TIMESTAMP = "timestamp";
    private static final String SIGN = "sign";
    private final RestContext context;
    private final Clock clock;

    protected RestRequest(IActor actor, RestContext context) {
        super(actor);
        this.context = context;
        this.clock = actor.getClock();
    }

    protected abstract RestMethod getMethod();

    protected abstract String getEndpointPath();

    protected abstract RestParams getParams();

    protected final RestCall createCall(ICredential credential) {
        RestMethod method = this.getMethod();
        switch (method) {
            case GET: 
            case DELETE: {
                return RestCall.newBuilder().setUrl(this.buildUrlWithParams(credential)).setMethod(method).build();
            }
            case POST: 
            case PUT: {
                return RestCall.newBuilder().setUrl(this.buildUrlWithoutParams()).setMethod(method).setBody(this.buildBody(credential)).build();
            }
        }
        throw new IllegalStateException(this.getMethod().name());
    }

    private String buildUrlWithParams(ICredential credential) {
        String url = this.buildUrlWithoutParams();
        RestParams params = this.getParams();
        if (!credential.isAnonymous()) {
            params = this.addSignature(params, credential);
        }
        if (!params.isEmpty()) {
            url = url + "?" + params.getQueryString();
        }
        return url;
    }

    private String buildUrlWithoutParams() {
        return this.context.getBaseUrl() + this.getEndpointPath();
    }

    private RestMediaBody buildBody(ICredential credential) {
        RestParams params = this.getParams();
        if (!credential.isAnonymous()) {
            params = this.addSignature(params, credential);
        }
        return RestMediaType.JSON.createBody(params);
    }

    private RestParams addSignature(RestParams params, ICredential credential) {
        TreeMap<String, String> paramMap = new TreeMap<String, String>((Map<String, String>)params.getValues());
        paramMap.put(API_KEY, credential.getApiKeyId());
        paramMap.put(TIMESTAMP, Long.toString(this.clock.millis()));
        String queryString = RestParams.toQueryString(paramMap);
        String sign = credential.sign(queryString);
        return RestParams.newBuilder().addAll(paramMap).add(SIGN, sign).build();
    }
}

